/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.DataValue;
import io.intino.alexandria.message.NullValue;
import java.lang.invoke.StringConcatFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Message {
    static final char listSeparator = '\u0001';
    private static final Value NullValue = new NullValue();
    private final Map<String, String> attributes;
    private String type;
    private Message owner;
    private List<Message> components;

    public Message(String type) {
        this.type = type;
        this.owner = null;
        this.attributes = new LinkedHashMap<String, String>();
        this.components = null;
    }

    public String type() {
        return this.type;
    }

    public boolean is(String type) {
        return type.equalsIgnoreCase(this.type);
    }

    public void type(String type) {
        this.type = type;
    }

    public List<String> attributes() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public Value get(String attribute) {
        return this.contains(attribute) ? new DataValue(this.attributes.get(attribute)) : NullValue;
    }

    public Message set(String attribute, Boolean value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Instant value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Long value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Integer value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Double value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, String value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public Message append(String attribute, Boolean value) {
        return this.append(attribute, value.toString());
    }

    public Message append(String attribute, Instant value) {
        return this.append(attribute, value.toString());
    }

    public Message append(String attribute, Long value) {
        return this.append(attribute, value.toString());
    }

    public Message append(String attribute, Integer value) {
        return this.append(attribute, value.toString());
    }

    public Message append(String attribute, Double value) {
        return this.append(attribute, value.toString());
    }

    public Message append(String attribute, String value) {
        String before = this.attributes.putIfAbsent(attribute, value);
        if (before != null) {
            this.attributes.put(attribute, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001", "\u0001"}, (String)before, value == null ? "\u0000" : value)));
        }
        return this;
    }

    public Message rename(String attribute, String newName) {
        this.attributes.put(newName, this.attributes.remove(attribute));
        return this;
    }

    public Message remove(String attribute) {
        this.attributes.remove(attribute);
        return this;
    }

    public Message remove(String attribute, Object value) {
        this.attributes.computeIfPresent(attribute, (k, v) -> v.replace(value.toString(), "").replace((CharSequence)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)String.valueOf('\u0001'))), String.valueOf('\u0001')));
        return this;
    }

    public List<Message> components() {
        return this.components == null ? new ArrayList<Message>() : new ArrayList<Message>(this.components);
    }

    public List<Message> components(String type) {
        ArrayList<Message> result = new ArrayList<Message>();
        if (this.components == null) {
            return result;
        }
        for (Message component : this.components) {
            if (!component.is(type)) continue;
            result.add(component);
        }
        return result;
    }

    public void add(Message component) {
        if (this.components == null) {
            this.components = new ArrayList<Message>();
        }
        this.components.add(component);
        component.owner = this;
    }

    public void add(List<Message> components) {
        if (components == null) {
            return;
        }
        for (Message component : components) {
            this.add(component);
        }
    }

    public void remove(Message component) {
        this.components.remove(component);
    }

    public void remove(List<Message> components) {
        this.components.removeAll(components);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.qualifiedType()).append("]\n");
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            sb.append(this.stringOf(attribute)).append("\n");
        }
        for (Message component : this.components()) {
            sb.append("\n").append(component.toString());
        }
        return sb.toString();
    }

    private String stringOf(Map.Entry<String, String> attribute) {
        return attribute.getKey() + ":" + (String)(this.isMultiline(attribute.getValue()) ? Message.indent(attribute.getValue()) : " " + attribute.getValue());
    }

    private boolean isMultiline(String value) {
        return value != null && value.contains("\n");
    }

    private String qualifiedType() {
        return this.owner != null ? this.owner.qualifiedType() + "." + this.type : this.type;
    }

    public int length() {
        return this.toString().length();
    }

    public boolean contains(String attribute) {
        return this.attributes.containsKey(attribute);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Message message = (Message)object;
        return Objects.equals(this.type, message.type) && this.attributes.keySet().stream().allMatch(k -> this.attributeEquals(message, (String)k)) && Objects.equals(this.components, message.components);
    }

    private boolean attributeEquals(Message message, String key) {
        return message.contains(key) && message.get(key).data().equals(this.get(key).data());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.owner, this.attributes, this.components);
    }

    private static String indent(String text) {
        return "\n\t" + text.replaceAll("\\n", "\n\t");
    }

    public static interface Value {
        public String data();

        public <T> T as(Class<T> var1);

        public Instant asInstant();

        public int asInteger();

        public Long asLong();

        public String asString();

        public double asDouble();

        public boolean asBoolean();

        public List<Value[]> asTable();
    }
}

