/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.security.AlexandriaSecurityManager;
import io.intino.alexandria.http.security.NullSecurityManager;
import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkRouter;
import io.intino.alexandria.logger.Logger;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ThreadPool;
import spark.ExceptionHandler;
import spark.ExceptionMapper;
import spark.Service;
import spark.Spark;
import spark.embeddedserver.EmbeddedServer;
import spark.embeddedserver.EmbeddedServerFactory;
import spark.embeddedserver.EmbeddedServers;
import spark.embeddedserver.jetty.EmbeddedJettyServer;
import spark.embeddedserver.jetty.JettyHandler;
import spark.embeddedserver.jetty.JettyServerFactory;
import spark.http.matching.MatcherFilter;
import spark.route.Routes;
import spark.staticfiles.StaticFilesConfiguration;

public class AlexandriaSpark<R extends SparkRouter> {
    private AlexandriaSecurityManager securityManager = new NullSecurityManager();
    protected final String webDirectory;
    protected PushService pushService;
    protected static final String WebDirectory = "/www";
    protected Service service;
    protected int port;
    protected ConnectionListener connectionListener;

    public AlexandriaSpark(int port) {
        this(port, WebDirectory);
    }

    public AlexandriaSpark(int port, String webDirectory) {
        this.port = port;
        this.webDirectory = webDirectory;
        this.service = Service.ignite();
        this.setup();
        this.service.port(this.port);
        this.service.exception(Exception.class, (exception, request, response) -> Logger.error(exception));
    }

    public AlexandriaSpark start() {
        this.service.init();
        return this;
    }

    public Service service() {
        return this.service;
    }

    public int activeThreadCount() {
        return this.service.activeThreadCount();
    }

    public ConnectionListener connectionListener() {
        return this.connectionListener;
    }

    public void stop() {
        if (this.service != null) {
            this.service.stop();
        }
        this.service = null;
    }

    public String webDirectory() {
        return this.webDirectory;
    }

    public void secure(AlexandriaSecurityManager manager) {
        this.securityManager = manager;
    }

    public R route(String path) {
        R router = this.createRouter(path);
        ((SparkRouter)router).inject(this.pushService);
        ((SparkRouter)router).whenRegisterPushService(this.pushServiceConsumer());
        ((SparkRouter)router).whenValidate(manager -> this.securityManager.check(manager.fromQuery("hash"), manager.fromQuery("signature")));
        return router;
    }

    public <T extends Exception> void handle(Class<T> exceptionClass, ExceptionHandler<? super T> handler) {
        this.service.exception(exceptionClass, handler);
    }

    private Consumer<PushService> pushServiceConsumer() {
        return pushService -> {
            this.pushService = pushService;
        };
    }

    protected R createRouter(String path) {
        return (R)new SparkRouter(this.service, path);
    }

    protected void setupStaticFiles() {
        if (this.webDirectory == null) {
            return;
        }
        if (this.isInClasspath(this.webDirectory)) {
            this.service.staticFileLocation(this.webDirectory);
        } else {
            this.service.externalStaticFileLocation(this.webDirectory);
        }
    }

    private boolean isInClasspath(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path) != null;
    }

    private void setup() {
        this.setupService();
        this.setupStaticFiles();
    }

    private void setupService() {
        EmbeddedServers.add((Object)EmbeddedServers.Identifiers.JETTY, new EmbeddedServerFactory(){

            @Override
            public EmbeddedServer create(Routes routes, StaticFilesConfiguration staticFilesConfiguration, boolean hasMultipleHandler) {
                return this.create(routes, staticFilesConfiguration, new ExceptionMapper(), hasMultipleHandler);
            }

            @Override
            public EmbeddedServer create(Routes routes, StaticFilesConfiguration staticFilesConfiguration, ExceptionMapper exceptionMapper, boolean hasMultipleHandler) {
                JettyHandler handler = AlexandriaSpark.setupRequestHandler(routes, staticFilesConfiguration, exceptionMapper, hasMultipleHandler);
                return new EmbeddedJettyServer(new JettyServerFactory(){

                    @Override
                    public Server create(int maxThreads, int minThreads, int threadTimeoutMillis) {
                        return this.server();
                    }

                    @Override
                    public Server create(ThreadPool threadPool) {
                        return this.server();
                    }

                    private Server server() {
                        Server newServer = new Server();
                        newServer.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", 0x6400000);
                        AlexandriaSpark.this.connectionListener = new ConnectionListener(newServer);
                        return newServer;
                    }
                }, handler);
            }
        });
    }

    private static JettyHandler setupRequestHandler(Routes routeMatcher, StaticFilesConfiguration staticFilesConfiguration, ExceptionMapper exceptionMapper, boolean hasMultipleHandler) {
        MatcherFilter matcherFilter = new MatcherFilter(routeMatcher, staticFilesConfiguration, exceptionMapper, false, hasMultipleHandler);
        matcherFilter.init(null);
        return new JettyHandler(matcherFilter);
    }

    static {
        Spark.initExceptionHandler(Logger::error);
    }

    public static class ConnectionListener {
        private final Server server;

        ConnectionListener(Server server) {
            this.server = server;
        }

        public List<String> currentConnectionSourceIps() {
            return this.server.getConnectors()[0].getConnectedEndPoints().stream().map(e -> new String(e.getRemoteAddress().getAddress().getAddress())).collect(Collectors.toList());
        }
    }

    public static interface ResourceCaller<SM extends SparkManager> {
        public void call(SM var1) throws AlexandriaException;
    }
}

