/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import java.net.URI;
import java.util.List;
import java.util.Properties;

public class ProxyUtils {
    private static final String PROPERTY_PREFIX = "com.ning.http.client.AsyncHttpClientConfig.proxy.";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String PROXY_PROTOCOL = "com.ning.http.client.AsyncHttpClientConfig.proxy.protocol";
    public static final String PROXY_NONPROXYHOSTS = "http.nonProxyHosts";
    public static final String PROXY_USER = "com.ning.http.client.AsyncHttpClientConfig.proxy.user";
    public static final String PROXY_PASSWORD = "com.ning.http.client.AsyncHttpClientConfig.proxy.password";

    public static boolean avoidProxy(ProxyServer proxyServer, Request request) {
        return ProxyUtils.avoidProxy(proxyServer, URI.create(request.getUrl()).getHost());
    }

    public static boolean avoidProxy(ProxyServer proxyServer, String target) {
        if (proxyServer != null) {
            String targetHost = target.toLowerCase();
            List<String> nonProxyHosts = proxyServer.getNonProxyHosts();
            if (nonProxyHosts != null && nonProxyHosts.size() > 0) {
                for (String nonProxyHost : nonProxyHosts) {
                    if (nonProxyHost.startsWith("*") && nonProxyHost.length() > 1 && targetHost.endsWith(nonProxyHost.substring(1).toLowerCase())) {
                        return true;
                    }
                    if (!nonProxyHost.equalsIgnoreCase(targetHost)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static ProxyServer createProxy(Properties properties) {
        String host = System.getProperty(PROXY_HOST);
        if (host != null) {
            ProxyServer.Protocol protocol;
            int port = Integer.valueOf(System.getProperty(PROXY_PORT, "80"));
            try {
                protocol = ProxyServer.Protocol.valueOf(System.getProperty(PROXY_PROTOCOL, "HTTP"));
            }
            catch (IllegalArgumentException e) {
                protocol = ProxyServer.Protocol.HTTP;
            }
            ProxyServer proxyServer = new ProxyServer(protocol, host, port, System.getProperty(PROXY_USER), System.getProperty(PROXY_PASSWORD));
            String nonProxyHosts = System.getProperties().getProperty(PROXY_NONPROXYHOSTS);
            if (nonProxyHosts != null) {
                for (String spec : nonProxyHosts.split("\\|")) {
                    proxyServer.addNonProxyHost(spec);
                }
            }
            return proxyServer;
        }
        return null;
    }
}

