/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.log.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.metadata.ConstraintDescriptor;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class MethodValidator {
    private final transient Validator validator = MethodValidator.build();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodValidator ajc$perSingletonInstance;

    @Before(value="execution(* *(.., @(javax.validation.* || javax.validation.constraints.*) (*), ..))")
    public void beforeMethod(JoinPoint point) {
        if (this.validator != null) {
            this.validate(point, ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod().getParameterAnnotations());
        }
    }

    @Before(value="preinitialization(*.new(.., @(javax.validation.* || javax.validation.constraints.*) (*), ..))")
    public void beforeCtor(JoinPoint point) {
        if (this.validator != null) {
            this.validate(point, ((ConstructorSignature)ConstructorSignature.class.cast(point.getSignature())).getConstructor().getParameterAnnotations());
        }
    }

    @AfterReturning(pointcut="execution(@(javax.validation.* || javax.validation.constraints.*) * *(..))", returning="result")
    public void after(JoinPoint point, Object result) {
        Set<ConstraintViolation<Object>> violations;
        Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
        if (method.isAnnotationPresent(NotNull.class) && result == null && !method.getReturnType().equals(Void.TYPE)) {
            throw new ConstraintViolationException(method.getAnnotation(NotNull.class).message(), new HashSet(Collections.singletonList(MethodValidator.violation(result, method.getAnnotation(NotNull.class).message()))));
        }
        if (method.isAnnotationPresent(Valid.class) && result != null && !(violations = this.validate(result)).isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    private void validate(JoinPoint point, Annotation[][] params) {
        HashSet violations = new HashSet(0);
        int pos = 0;
        while (pos < params.length) {
            violations.addAll(this.validate(pos, point.getArgs()[pos], params[pos]));
            ++pos;
        }
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(MethodValidator.pack(violations), violations);
        }
    }

    private Set<ConstraintViolation<?>> validate(int pos, Object arg, Annotation[] annotations) {
        HashSet violations = new HashSet(0);
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation antn = annotationArray[n2];
            if (antn.annotationType().equals(NotNull.class)) {
                if (arg == null) {
                    violations.add(MethodValidator.violation(String.format("param #%d", pos), ((NotNull)NotNull.class.cast(antn)).message()));
                }
            } else if (antn.annotationType().equals(Valid.class) && arg != null) {
                violations.addAll((Collection)this.validate(arg));
            } else if (antn.annotationType().equals(Pattern.class)) {
                if (arg != null && !arg.toString().matches(((Pattern)Pattern.class.cast(antn)).regexp())) {
                    violations.add(MethodValidator.violation(String.format("param #%d '%s'", pos, arg), ((Pattern)Pattern.class.cast(antn)).message()));
                }
            } else if (antn.annotationType().isAnnotationPresent(Constraint.class)) {
                Logger.warn(this, "%[type]s annotation is not supported at the moment", antn.annotationType());
            }
            ++n2;
        }
        return violations;
    }

    private static ConstraintViolation<?> violation(final Object arg, final String msg) {
        return new ConstraintViolation<String>(){

            public String toString() {
                return String.format("%s %s", arg, msg);
            }

            @Override
            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return null;
            }

            @Override
            public Object getInvalidValue() {
                return arg;
            }

            @Override
            public Object getLeafBean() {
                return null;
            }

            @Override
            public String getMessage() {
                return msg;
            }

            @Override
            public String getMessageTemplate() {
                return msg;
            }

            @Override
            public Path getPropertyPath() {
                return null;
            }

            @Override
            public String getRootBean() {
                return "";
            }

            @Override
            public Class<String> getRootBeanClass() {
                return String.class;
            }

            @Override
            public Object[] getExecutableParameters() {
                return new Object[0];
            }

            @Override
            public Object getExecutableReturnValue() {
                return null;
            }

            @Override
            public <U> U unwrap(Class<U> type) {
                return null;
            }
        };
    }

    private static String pack(Collection<ConstraintViolation<?>> errs) {
        StringBuilder text = new StringBuilder(0);
        for (ConstraintViolation<?> violation : errs) {
            if (text.length() > 0) {
                text.append("; ");
            }
            text.append(violation.getMessage());
        }
        return text.toString();
    }

    private static Validator build() {
        Validator val = null;
        try {
            val = Validation.buildDefaultValidatorFactory().getValidator();
            Logger.info(MethodValidator.class, "JSR-303 validator %[type]s instantiated by jcabi-aspects 0.18/5fe49a2", val);
        }
        catch (ValidationException ex) {
            Logger.error(MethodValidator.class, "JSR-303 validator failed to initialize: %s (see http://aspects.jcabi.com/jsr-303.html)", ex.getMessage());
        }
        catch (Throwable ex) {
            Logger.error(MethodValidator.class, "JSR-303 validator thrown during initialization: %[exception]s", ex);
        }
        return val;
    }

    private <T> Set<ConstraintViolation<T>> validate(T object) {
        Set<ConstraintViolation<T>> violations;
        try {
            violations = this.validator.validate(object, new Class[0]);
        }
        catch (Throwable ex) {
            Logger.error(this, "JSR-303 validator %[type]s thrown %s while validating %[type]s", this.validator, ex, object);
            violations = new HashSet<ConstraintViolation<T>>(0);
        }
        return violations;
    }

    public static MethodValidator aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodValidator", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodValidator.ajc$perSingletonInstance = new MethodValidator();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

