/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.internal.engine.ValidatorFactoryImpl;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public class ValidatorContextImpl
implements HibernateValidatorContext {
    private final ValidatorFactoryImpl validatorFactory;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private ParameterNameProvider parameterNameProvider;
    private boolean failFast;
    private final List<ValidatedValueUnwrapper<?>> validatedValueHandlers;

    public ValidatorContextImpl(ValidatorFactoryImpl validatorFactory) {
        this.validatorFactory = validatorFactory;
        this.messageInterpolator = validatorFactory.getMessageInterpolator();
        this.traversableResolver = validatorFactory.getTraversableResolver();
        this.constraintValidatorFactory = validatorFactory.getConstraintValidatorFactory();
        this.parameterNameProvider = validatorFactory.getParameterNameProvider();
        this.failFast = validatorFactory.isFailFast();
        this.validatedValueHandlers = new ArrayList(validatorFactory.getValidatedValueHandlers());
    }

    @Override
    public HibernateValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator == null ? this.validatorFactory.getMessageInterpolator() : messageInterpolator;
        return this;
    }

    @Override
    public HibernateValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver == null ? this.validatorFactory.getTraversableResolver() : traversableResolver;
        return this;
    }

    @Override
    public HibernateValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        this.constraintValidatorFactory = factory == null ? this.validatorFactory.getConstraintValidatorFactory() : factory;
        return this;
    }

    @Override
    public HibernateValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider == null ? this.validatorFactory.getParameterNameProvider() : parameterNameProvider;
        return this;
    }

    @Override
    public HibernateValidatorContext failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public HibernateValidatorContext addValidationValueHandler(ValidatedValueUnwrapper<?> handler) {
        this.validatedValueHandlers.add(handler);
        return this;
    }

    @Override
    public Validator getValidator() {
        return this.validatorFactory.createValidator(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.parameterNameProvider, this.failFast, this.validatedValueHandlers);
    }
}

