/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Model;
import io.intino.magritte.framework.NodeCloner;
import io.intino.magritte.framework.Predicate;
import io.intino.magritte.framework.utils.StashHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Node
extends Predicate {
    final List<Layer> layers = new ArrayList<Layer>();
    private Node owner;

    public Node() {
        this("");
    }

    public Node(String id) {
        super(id);
    }

    private static <T> List<T> reverseListOf(List<T> list) {
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.reverse(result);
        return result;
    }

    public Node owner() {
        return this.owner;
    }

    public <T extends Layer> T ownerAs(Class<T> layerClass) {
        if (this.owner == null) {
            return null;
        }
        if (this.owner.is(layerClass)) {
            return this.owner.as(layerClass);
        }
        return this.owner.ownerAs(layerClass);
    }

    public Node clone(Node parent) {
        NodeCloner.clone(Collections.singletonList(this), parent, this.graph());
        return this.graph().node(parent.id() + "." + this.name());
    }

    public Node clone(String stash) {
        NodeCloner.clone(Collections.singletonList(this), this.model(), stash, this.graph());
        return this.graph().node(stash + "#" + this.name());
    }

    @Override
    public List<Concept> conceptList() {
        ArrayList<Concept> result = new ArrayList<Concept>();
        Graph graph = this.graph();
        for (String typeName : this.typeNames) {
            result.add(graph.concept(typeName));
        }
        Collections.reverse(result);
        return result;
    }

    public List<String> layerList() {
        ArrayList<String> aspectList = new ArrayList<String>(this.typeNames);
        Collections.reverse(aspectList);
        return aspectList;
    }

    public Model model() {
        Node node = this;
        while (node.owner != null) {
            node = node.owner;
        }
        return (Model)node;
    }

    public Graph graph() {
        return this.model().graph();
    }

    public String stash() {
        return StashHelper.pathOf(this.id);
    }

    public Node root() {
        return this.graph().load(this.rootNodeId());
    }

    public void createNode(String name, Concept concept) {
        this.add(concept.createNode(name, this));
    }

    public void add(Node node) {
        for (Layer layer : this.layers) {
            layer.addNode$(node);
        }
    }

    @Override
    public List<Node> componentList() {
        LinkedHashSet nodes = new LinkedHashSet();
        Node.reverseListOf(this.layers).forEach(l -> nodes.addAll(l.componentList$()));
        return new ArrayList<Node>(nodes);
    }

    public <T extends Layer> List<T> componentList(Class<T> layerClass) {
        List<String> types = this.graph().layerFactory.names(layerClass);
        return this.componentList().stream().filter(c -> c.isAnyOf(types)).map(c -> c.as(layerClass)).collect(Collectors.toList());
    }

    @Override
    public <T extends Layer> List<T> findNode(Class<T> layerClass) {
        ArrayList tList = new ArrayList();
        if (this.is(layerClass)) {
            tList.add(this.as(layerClass));
        }
        this.componentList().forEach(c -> tList.addAll(c.findNode(layerClass)));
        return tList;
    }

    public <T extends Layer> T as(Class<T> layerClass) {
        for (Layer layer : this.layers) {
            if (!layerClass.isAssignableFrom(layer.getClass())) continue;
            return (T)layer;
        }
        return null;
    }

    public Layer as(String conceptName) {
        return this.as(this.graph().layerFactory.layerClass(conceptName));
    }

    public void load(Layer layer, String name, List<?> values) {
        if (layer.core$() == this) {
            layer.load$(name, values);
        } else {
            Logger.getGlobal().severe("Layer does not belong to node " + name);
        }
    }

    public void set(Layer layer, String name, List<?> values) {
        if (layer.core$() == this) {
            layer.set$(name, values);
        } else {
            Logger.getGlobal().severe("Layer does not belong to node " + name);
        }
    }

    @Override
    public Map<String, List<?>> variables() {
        HashMap variables = new HashMap();
        this.layers.forEach(m -> variables.putAll(m.variables$()));
        return variables;
    }

    public void save() {
        this.graph().save(this);
    }

    public void delete() {
        this.graph().remove(this);
    }

    public boolean is(String concept) {
        return this.typeNames.contains(concept);
    }

    public boolean is(Concept concept) {
        return this.typeNames.contains(concept.id());
    }

    public boolean is(Class<? extends Layer> layer) {
        return this.isAnyOf(this.concepts(layer));
    }

    public Layer as(Concept concept) {
        return this.as(concept.id);
    }

    private void createLayer(Concept concept) {
        Layer layer = this.graph().layerFactory.create(concept.id, this);
        if (layer != null) {
            this.layers.add(0, layer);
        }
    }

    private void createLayer(Class<? extends Layer> layerClass) {
        Layer layer = this.graph().layerFactory.create(layerClass, this);
        if (layer != null) {
            this.layers.add(0, layer);
        }
    }

    private void removeParentLayer(Concept concept) {
        if (concept.parent() == null || concept.parent().isAbstract()) {
            return;
        }
        Layer toRemove = null;
        for (Layer layer : this.layers) {
            if (layer.getClass() != concept.parent().layerClass) continue;
            toRemove = layer;
            break;
        }
        if (toRemove != null) {
            this.layers.remove(toRemove);
        }
    }

    protected void remove(Node node) {
        this.layers.forEach(l -> l.removeNode$(node));
    }

    public <T extends Layer> T addAspect(Class<T> layerClass) {
        return (T)this.addAspect(this.graph().concept(layerClass));
    }

    public Layer addAspect(String concept) {
        return this.addAspect(this.graph().concept(concept));
    }

    public Layer addAspect(Concept concept) {
        this.model().remove(this);
        concept.prepareNode(this, this.graph());
        this.model().add(this);
        return this.as(concept);
    }

    void addLayers(List<Concept> concepts) {
        concepts.forEach(this::addLayer);
    }

    void addLayer(Class<? extends Layer> layerClass) {
        this.createLayer(layerClass);
    }

    Node addLayer(Concept concept) {
        if (this.is(concept.id)) {
            return this;
        }
        this.putType(concept);
        this.createLayer(concept);
        this.removeParentLayer(concept);
        return this;
    }

    void removeAspects(List<Concept> concepts) {
        concepts.forEach(this::removeAspect);
    }

    public void removeAspect(Class<? extends Layer> layerClass) {
        this.removeAspect(this.graph().layerFactory.names(layerClass).get(0));
    }

    public void removeAspect(String concept) {
        this.removeAspect(this.graph().concept(concept));
    }

    public void removeAspect(Concept concept) {
        if (!this.is(concept.id()) || !concept.isAspect()) {
            return;
        }
        this.model().remove(this);
        HashSet<Concept> toRemove = new HashSet<Concept>(Concept.metaTypesOf(Collections.singletonList(concept)));
        toRemove.addAll(concept.allChildren());
        toRemove.addAll(concept.allInstances());
        toRemove.forEach(c -> this.typeNames.remove(c.id()));
        List<Concept> list = this.conceptList();
        this.typeNames.clear();
        list.forEach(c -> Concept.metaTypesOf(Collections.singletonList(c)).forEach(c1 -> this.typeNames.add(c1.id())));
        toRemove.stream().filter(r -> !this.typeNames.contains(r.id())).forEach(r -> this.layers.remove(this.as(r.layerClass)));
        this.model().add(this);
    }

    boolean isAnyOf(List<String> concepts) {
        return concepts.stream().anyMatch(this::is);
    }

    void owner(Node owner) {
        this.owner = owner;
    }

    void load(String varName, List<?> value) {
        this.layers.forEach(l -> l.load$(varName, value));
    }

    void set(String varName, List<?> value) {
        this.layers.forEach(l -> l.set$(varName, value));
    }

    private List<String> concepts(Class<? extends Layer> layerClass) {
        return this.graph().layerFactory.names(layerClass);
    }

    void syncLayers() {
        this.layers.forEach(l -> this.layers.forEach(l::sync$));
    }
}

