/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners.index;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.reflect.Streams;
import org.sonatype.guice.bean.scanners.ClassFinder;
import org.sonatype.guice.bean.scanners.index.SisuIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SisuIndexFinder
implements ClassFinder {
    private final boolean globalIndex;

    public SisuIndexFinder(boolean globalIndex) {
        this.globalIndex = globalIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findClasses(ClassSpace space) {
        ArrayList<URL> components = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        Enumeration<URL> indices = this.globalIndex ? space.getResources("META-INF/sisu/" + SisuIndex.NAMED) : space.findEntries("META-INF/sisu/", SisuIndex.NAMED, false);
        while (indices.hasMoreElements()) {
            URL url = indices.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(Streams.open(url)));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        URL clazz;
                        if (visited.add(line) && null != (clazz = space.getResource(line.replace('.', '/') + ".class"))) {
                            components.add(clazz);
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logs.warn("Problem reading: {}", url, e);
            }
        }
        return Collections.enumeration(components);
    }
}

