/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.io;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DeflateSerializer;
import io.intino.magritte.io.LocalDateTimeSerializer;
import io.intino.magritte.io.Stash;
import io.intino.magritte.io.StoreException;
import java.io.IOException;
import java.time.LocalDateTime;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class StashSerializer {
    private static final Kryo kryo = new Kryo();

    private StashSerializer() {
    }

    public static byte[] serialize(Stash stash) {
        try {
            return StashSerializer.doSerialize(stash);
        }
        catch (IOException e) {
            throw new StoreException(e.getMessage());
        }
    }

    private static byte[] doSerialize(Stash stash) throws IOException {
        try (Output output = new Output(4096, -1);){
            kryo.writeObject(output, stash);
            output.flush();
            output.close();
            byte[] byArray = output.toBytes();
            return byArray;
        }
    }

    static {
        kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
        kryo.register(Stash.class, new DeflateSerializer(kryo.getDefaultSerializer(Stash.class)));
        kryo.register(LocalDateTime.class, new LocalDateTimeSerializer());
    }
}

