/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SyncHandler {
    private final File appsWorkspace;
    private final String deployUser;
    private final List<Process> rsyncProcesses = new ArrayList<Process>();

    public SyncHandler(File appsWorkspace, String deployUser) {
        this.appsWorkspace = appsWorkspace;
        this.deployUser = deployUser;
    }

    public void sync(String directory, List<String> targetServers) {
        for (String targetServer : targetServers) {
            try {
                Process process = new ProcessBuilder("sudo", "-u", this.deployUser, "bash", "/opt/scripts/rsync-continuous", this.appsWorkspace.getAbsolutePath() + File.separator + directory, targetServer + File.separator + directory).directory(this.appsWorkspace).inheritIO().start();
                Logger.info("Sync process attached with pid: " + process.toHandle().pid());
                this.rsyncProcesses.add(process);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }

    void stop() {
        this.rsyncProcesses.forEach(Process::destroy);
    }
}

