/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zet;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZOutputStream;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Stream;

public class ZetBuilder {
    private final File source;

    public ZetBuilder(File file) {
        this.source = file;
        file.getParentFile().mkdirs();
    }

    public void put(long ... data) {
        this.put(new ZetReader(data));
    }

    public void put(List<Long> messages) {
        this.put(new ZetReader(messages));
    }

    public void put(Stream<Long> stream) {
        this.put(new ZetReader(stream));
    }

    public void put(ZetStream stream) {
        try {
            Files.move(this.merge(stream).toPath(), this.source.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private File merge(ZetStream data) {
        File file = this.tempFile();
        try (ZOutputStream os = this.zipStream(file);){
            ZetStream stream = this.mergeFileWith(data);
            while (stream.hasNext()) {
                os.writeLong(stream.next());
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return file;
    }

    private ZOutputStream zipStream(File file) throws IOException {
        return new ZOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    private File tempFile() {
        try {
            return File.createTempFile("merge", "zim");
        }
        catch (IOException e) {
            Logger.error(e);
            return new File("merge");
        }
    }

    private ZetStream mergeFileWith(ZetStream stream) {
        return new ZetStream.Union(new ZetReader(this.source), stream);
    }
}

