/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zet;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ZOutputStream
extends OutputStream {
    private DataOutputStream output;
    private long base = -1L;
    private byte[] data = new byte[256];
    private int count = 0;
    private int size = 0;

    public ZOutputStream(OutputStream outputStream) {
        this.output = new DataOutputStream(outputStream);
    }

    @Override
    public void write(int b) {
    }

    public void writeLong(long id) {
        this.base(id >> 8);
        if (this.isRepeated((byte)id)) {
            return;
        }
        this.data[this.count++] = (byte)id;
        ++this.size;
    }

    private boolean isRepeated(byte b) {
        return this.count > 0 && this.data[this.count - 1] == b;
    }

    private void base(long base) {
        try {
            if (this.base == base) {
                return;
            }
            this.writeData();
            this.writeBase(base);
            this.base = base;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeBase(long base) throws IOException {
        int level = this.base >= 0L ? this.level(base, this.base) : this.level(base);
        this.output.writeByte(level);
        for (int i = level - 1; i >= 0; --i) {
            byte b = (byte)(base >> (i << 3));
            this.output.writeByte(b);
        }
    }

    private int level(long base) {
        return base != 0L ? this.level(base >> 8) + 1 : 0;
    }

    private int level(long a, long b) {
        return a != b ? this.level(a >> 8, b >> 8) + 1 : 0;
    }

    private void writeData() throws IOException {
        if (this.base < 0L) {
            return;
        }
        this.output.writeByte(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.output.writeByte(this.data[i]);
        }
        this.count = 0;
    }

    @Override
    public void close() throws IOException {
        this.writeData();
        this.output.writeLong(-1L);
        this.output.writeLong(this.size);
        this.output.close();
    }
}

