/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zet;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ZInputStream
extends InputStream {
    private final DataInputStream input;
    private long base = 0L;
    private byte[] data = new byte[256];
    private int count = 0;
    private int index = 0;
    private int size = 0;

    public ZInputStream(InputStream inputStream) {
        this.input = new DataInputStream(inputStream);
        this.init();
    }

    private void init() {
        try {
            this.readBlock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public int read() {
        return 0;
    }

    public long readLong() throws IOException {
        if (this.index == this.count) {
            this.readBlock();
        }
        return this.base << 8 | (long)(this.data[this.index++] & 0xFF);
    }

    private void readBlock() throws IOException {
        this.readBase();
        this.readData();
    }

    private void readBase() throws IOException {
        int level = this.input.read();
        if (level < 0) {
            throw new EOFException();
        }
        this.base >>= level << 3;
        for (int i = 1; i <= level; ++i) {
            this.base = this.base << 8 | (long)(this.input.readByte() & 0xFF);
        }
    }

    private void readData() throws IOException {
        this.count = this.input.readByte() & 0xFF;
        if (this.count == 0) {
            this.count = 256;
        }
        this.size += this.count;
        this.index = 0;
        this.input.read(this.data, 0, this.count);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

