/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.lang.semantics.constraints;

import io.intino.magritte.Resolver;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Element;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Parametrized;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.model.rules.variable.VariableRule;
import io.intino.magritte.lang.semantics.Assumption;
import io.intino.magritte.lang.semantics.Constraint;
import io.intino.magritte.lang.semantics.constraints.AspectConstraint;
import io.intino.magritte.lang.semantics.constraints.MetaAspectConstraint;
import io.intino.magritte.lang.semantics.constraints.component.Component;
import io.intino.magritte.lang.semantics.constraints.component.OneOf;
import io.intino.magritte.lang.semantics.constraints.parameter.PrimitiveParameter;
import io.intino.magritte.lang.semantics.constraints.parameter.ReferenceParameter;
import io.intino.magritte.lang.semantics.errorcollector.SemanticException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RuleFactory {
    private RuleFactory() {
    }

    public static Constraint.Component component(String type, List<Rule> rules, Tag ... flags) {
        return new Component(type, rules, Arrays.asList(flags));
    }

    @Deprecated
    public static Constraint.Component component(String type, Rule rule, Tag ... flags) {
        return new Component(type, Collections.singletonList(rule), Arrays.asList(flags));
    }

    public static Constraint.OneOf oneOf(List<Rule> rules, Constraint.Component ... components) {
        return new OneOf(Arrays.asList(components), rules);
    }

    public static Constraint.Parameter parameter(String name, Primitive type, String aspect, Size size, int position, String scope, VariableRule rule, Tag ... tags) {
        return new PrimitiveParameter(name, type, aspect, size, position, scope, rule, Arrays.asList(tags));
    }

    public static Constraint.Parameter parameter(String name, String type, String aspect, Size size, int position, String scope, VariableRule rule, Tag ... tags) {
        return new ReferenceParameter(name, type, aspect, size, position, scope, rule, Arrays.asList(tags));
    }

    public static Constraint.Aspect aspect(String type, boolean terminal, String[] with, String[] without) {
        return RuleFactory.aspect(type, terminal, false, with, without);
    }

    public static Constraint.Aspect aspect(String type, boolean terminal, boolean required, String[] with, String[] without) {
        return new AspectConstraint(type, terminal, required, with, without);
    }

    public static Constraint.MetaAspect metaAspect(String type, String ... with) {
        return new MetaAspectConstraint(type, with);
    }

    public static Constraint.ComponentNotFound rejectOtherComponents(final List<String> types) {
        return new Constraint.ComponentNotFound(){

            @Override
            public void check(Element element) throws SemanticException {
                NodeContainer node = (NodeContainer)element;
                for (Node component : node.components()) {
                    if (RuleFactory.areCompatibles(component, types)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.type.not.exists", component, Collections.singletonList(component.type().replace(":", ""))));
                }
            }
        };
    }

    private static boolean areCompatibles(Node node, List<String> allowedTypes) {
        return node.types().stream().anyMatch(type -> type != null && (allowedTypes.contains(type) || node.container() != null && RuleFactory.fromAspect(node.container().appliedAspects(), type, allowedTypes))) || RuleFactory.checkAspect(node, allowedTypes);
    }

    public static Constraint.RejectOtherParameters rejectOtherParameters(final List<Constraint.Parameter> parameters) {
        return new Constraint.RejectOtherParameters(){

            @Override
            public void check(Element element) throws SemanticException {
                Parametrized parametrized = (Parametrized)((Object)element);
                for (Parameter parameter : parametrized.parameters()) {
                    if (this.isAcceptable(parameter, parameters)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.other.parameter.in.context", parameter, Collections.singletonList(parameter.name())));
                }
            }

            private boolean isAcceptable(Parameter parameter, List<Constraint.Parameter> parameters2) {
                for (Constraint.Parameter constraint : parameters2) {
                    if (!constraint.name().equals(parameter.name()) || !this.hasAspect(constraint.aspect(), parameter.container().appliedAspects())) continue;
                    return true;
                }
                return false;
            }

            private boolean hasAspect(String requiredAspect, List<Aspect> aspects) {
                if (requiredAspect.isEmpty()) {
                    return true;
                }
                for (Aspect aspect : aspects) {
                    if (!aspect.type().equals(requiredAspect)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Constraint.RejectOtherAspects rejectOtherAspects(final List<Constraint.Aspect> aspects) {
        return new Constraint.RejectOtherAspects(){

            @Override
            public void check(Element element) throws SemanticException {
                Node node = (Node)element;
                for (Aspect aspect : node.appliedAspects()) {
                    if (this.isAcceptable(aspects, aspect)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.other.aspect.in.context", aspect, Collections.singletonList(aspect.type())));
                }
            }

            private boolean isAcceptable(List<Constraint.Aspect> aspects2, Aspect aspect) {
                return aspects2.stream().anyMatch(a -> a.type().equals(aspect.fullType()));
            }
        };
    }

    private static boolean fromAspect(List<Aspect> aspects, String nodeType, List<String> types) {
        return RuleFactory.aspectComponent(aspects, nodeType, types) || RuleFactory.asAspect(aspects, nodeType.split(":")[0]);
    }

    private static boolean aspectComponent(List<Aspect> aspects, String nodeType, List<String> types) {
        return aspects.stream().anyMatch(aspect -> types.contains(nodeType));
    }

    private static boolean asAspect(List<Aspect> aspects, String aspect) {
        return aspects.stream().anyMatch(a -> a.type().equals(aspect));
    }

    private static boolean checkAspect(Node node, List<String> types) {
        List shortTypes = types.stream().map(Resolver::shortType).collect(Collectors.toList());
        return node.appliedAspects().stream().anyMatch(aspect -> shortTypes.contains(aspect.type()));
    }

    public static Constraint name() {
        return new Constraint.Name(){

            @Override
            public void check(Element element) throws SemanticException {
                Node node = (Node)element;
                if (!node.isReference() && node.name().isEmpty()) {
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "required.name", element, Collections.emptyList()));
                }
            }
        };
    }

    public static Constraint.TerminalVariableRedefinition redefine(final String name, final String superType) {
        return new Constraint.TerminalVariableRedefinition(){

            @Override
            public void check(Element element) throws SemanticException {
                Node node = (Node)element;
                if (!node.flags().contains((Object)Tag.Instance)) {
                    for (Variable variable : node.variables()) {
                        if (!name.equals(variable.name())) continue;
                        return;
                    }
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "required.terminal.variable.redefine", node, Arrays.asList(name, superType)));
                }
            }
        };
    }

    public static Assumption isAspect() {
        return new Assumption.Aspect(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Aspect)) {
                    node.addFlags(Tag.Aspect);
                }
                if (!node.flags().contains((Object)Tag.Terminal)) {
                    node.addFlags(Tag.Terminal);
                }
            }
        };
    }

    public static Assumption isAspectInstance() {
        return new Assumption.AspectInstance(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.AspectInstance)) {
                    node.addFlags(Tag.AspectInstance);
                }
            }
        };
    }

    public static Assumption isFeature() {
        return new Assumption.Feature(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Feature)) {
                    node.addFlags(Tag.Feature);
                }
                RuleFactory.propagateFlags(node, Tag.Feature);
            }
        };
    }

    public static Assumption isTerminal() {
        return new Assumption.Terminal(){

            @Override
            public void assume(Node node) {
                if (node.isReference()) {
                    return;
                }
                if (!node.flags().contains((Object)Tag.Terminal)) {
                    node.addFlags(Tag.Terminal);
                }
                node.variables().stream().filter(variable -> !variable.flags().contains((Object)Tag.Terminal)).forEach(variable -> variable.addFlags(Tag.Terminal));
                RuleFactory.propagateFlags(node, Tag.Terminal);
            }
        };
    }

    public static Assumption isVolatile() {
        return new Assumption.Volatile(){

            @Override
            public void assume(Node node) {
                if (node.isReference()) {
                    return;
                }
                if (!node.flags().contains((Object)Tag.Volatile)) {
                    node.addFlags(Tag.Volatile);
                }
                RuleFactory.propagateFlags(node, Tag.Volatile);
            }
        };
    }

    public static Assumption isComponent() {
        return new Assumption.Component(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Component)) {
                    node.addFlags(Tag.Component);
                }
            }
        };
    }

    public static Assumption isInstance() {
        return new Assumption.Instance(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Instance)) {
                    node.addFlags(Tag.Instance);
                }
                node.variables().stream().filter(variable -> !variable.flags().contains((Object)Tag.Instance)).forEach(variable -> variable.addFlags(Tag.Instance));
                RuleFactory.propagateFlags(node, Tag.Instance);
            }
        };
    }

    public static Assumption stashNodeName(final String stashNodeName) {
        return new Assumption.StashNodeName(){

            @Override
            public String stashNodeName() {
                return stashNodeName;
            }

            @Override
            public void assume(Node node) {
                node.stashNodeName(stashNodeName);
            }
        };
    }

    private static void propagateFlags(Node node, Tag tag) {
        for (Node component : node.components()) {
            if (component.isReference() || component.flags().contains((Object)tag)) continue;
            component.addFlags(tag);
            if (component.equals(node)) continue;
            RuleFactory.propagateFlags(component, tag);
        }
    }
}

