/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.terminal.Connector;
import io.intino.cesar.datahub.events.ProcessStatus;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.ProcessStatusAction;

public class ProcessStatusRequest
implements Connector.MessageConsumer {
    private ConsulBox box;

    public ProcessStatusRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void accept(String request, String callback) {
        try {
            ProcessStatus status = this.actionFor(this.processId(request)).execute();
            this.feed(status);
            this.box.datahubConnector().sendMessage(callback, status.toString());
        }
        catch (Throwable e) {
            Logger.error(e.getMessage(), e);
        }
    }

    private void feed(ProcessStatus status) {
        this.box.terminal().publish(status);
    }

    private String processId(String request) {
        return new MessageReader(request).next().get("processId").asString();
    }

    private ProcessStatusAction actionFor(String processId) {
        ProcessStatusAction action = new ProcessStatusAction();
        action.box = this.box;
        action.processId = processId;
        return action;
    }
}

