/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.rest.resources;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkPushService;
import io.intino.alexandria.rest.RequestAdapter;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.ResponseAdapter;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.PostChangeProcessStatusAction;

public class PostChangeProcessStatusResource
implements Resource {
    private ConsulBox box;
    private SparkManager<SparkPushService> manager;

    public PostChangeProcessStatusResource(ConsulBox box, SparkManager manager) {
        this.box = box;
        this.manager = manager;
    }

    @Override
    public void execute() throws BadRequest {
        this.write(this.fill(new PostChangeProcessStatusAction()).execute());
    }

    private PostChangeProcessStatusAction fill(PostChangeProcessStatusAction action) {
        action.box = this.box;
        action.context = this.context();
        action.process = RequestAdapter.adapt(this.manager.fromPath("process"), String.class);
        action.status = RequestAdapter.adapt(this.manager.fromQuery("status"), String.class);
        action.debugging = RequestAdapter.adapt(this.manager.fromQueryOrDefault("debugging", "false"), Boolean.class);
        return action;
    }

    private void write(Boolean object) {
        this.manager.write(ResponseAdapter.adapt(object));
    }

    private SparkContext context() {
        SparkContext context = new SparkContext(this.manager);
        return context;
    }
}

