/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.Utils;
import io.intino.consul.box.process.ProcessHandler;
import io.intino.consul.graph.Process;
import java.io.File;

public class ProcessManager {
    private ConsulBox box;

    public ProcessManager(ConsulBox box) {
        this.box = box;
    }

    public DeployResult deploy(Process process) {
        try {
            this.stop(process);
            ProcessHandler handler = this.createProcessHandler(process);
            handler.create();
            handler.start(0);
            process.processHandler(handler);
            process.deployed(true);
            process.save$();
            return new DeployResult().success(true).remarks("Deployed successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            process.deployed(false);
            process.save$();
            Logger.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            return new DeployResult().success(false).remarks(e.getMessage());
        }
    }

    public boolean retract(Process process) {
        if (process != null) {
            this.reset(process);
            new File(process.graph().core$().store().resourceFrom(process.logFileName()).getFile()).delete();
            Utils.removeDirectory(new File(this.box.applicationsDirectory(), process.identifier().replace(":", "_")));
            process.delete$();
            return true;
        }
        return false;
    }

    public boolean reset(Process process) {
        if (process != null) {
            this.stop(process);
            ProcessHandler processHandler = process.processHandler();
            if (processHandler != null) {
                processHandler.removeAppHomeDirectory();
            }
            return true;
        }
        return false;
    }

    public boolean debug(Process process, Integer port) {
        if (process == null || !this.isDeployed(process)) {
            return false;
        }
        try {
            this.stop(process);
            Thread.sleep(1000L);
            if (process.processHandler() == null) {
                process.processHandler(this.createProcessHandler(process));
            }
            process.processHandler().start(port);
            return true;
        }
        catch (Exception e) {
            Logger.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            return false;
        }
    }

    public boolean start(Process process) {
        if (process == null || !this.isDeployed(process)) {
            return false;
        }
        if (this.isRunning(process)) {
            return true;
        }
        try {
            if (process.processHandler() == null) {
                process.processHandler(this.createProcessHandler(process));
            }
            process.processHandler().start(0);
            return true;
        }
        catch (Exception e) {
            Logger.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            return false;
        }
    }

    private ProcessHandler createProcessHandler(Process process) {
        return new ProcessHandler(process, this.box.deployUser(), this.box.deployGroup(), this.box.applicationsWorkspace(), this.box.applicationsDirectory().getAbsoluteFile(), this.box.localRepository(), this.box.logHandler());
    }

    public boolean stop(Process process) {
        if (process == null) {
            return false;
        }
        if (process.processHandler() != null) {
            process.processHandler().stop();
            Logger.info("Process " + process.identifier() + " stopped");
            return true;
        }
        return false;
    }

    public boolean kill(Process process) {
        if (process == null) {
            return false;
        }
        if (process.processHandler() != null) {
            process.processHandler().kill();
            return true;
        }
        return false;
    }

    public boolean restart(Process process) {
        try {
            this.stop(process);
            Thread.sleep(1000L);
            this.start(process);
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public boolean isRunning(Process process) {
        return process != null && process.processHandler() != null && process.processHandler().isRunning();
    }

    public int exitValue(Process process) {
        return process != null && process.processHandler() != null ? process.processHandler().exitValue() : -1000;
    }

    private boolean isDeployed(Process process) {
        return process.deployed();
    }
}

