/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.LibraryResolver;
import io.intino.consul.box.Utils;
import io.intino.consul.box.process.ProcessLogHandler;
import io.intino.consul.graph.Process;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class ProcessHandler {
    public static final String COULD_NOT_FIND_ARTIFACT = "Could not find artifact";
    public static final String COULD_NOT_TRANSFER_ARTIFACT = "Could not transfer artifact";
    private final File appRunDirectory;
    private final File appHomeDirectory;
    private final String deployUser;
    private final String deployGroup;
    private final File localRepository;
    private io.intino.consul.graph.Process process;
    private ProcessLogHandler processLogHandler;
    private transient Process systemProcess;

    public ProcessHandler(io.intino.consul.graph.Process process, String deployUser, String deployGroup, File appsHome, File applicationsDirectory, File localRepository, ProcessLogHandler processLogHandler) {
        this.deployUser = deployUser;
        this.deployGroup = deployGroup;
        this.localRepository = localRepository;
        this.processLogHandler = processLogHandler;
        this.process = process;
        this.appHomeDirectory = new File(appsHome, process.appDirectoryName());
        this.appRunDirectory = new File(applicationsDirectory, process.appDirectoryName());
        this.appRunDirectory.mkdirs();
    }

    void create() throws Exception {
        List<Artifact> artifacts;
        try {
            artifacts = this.resolveArtifacts();
        }
        catch (DependencyResolutionException e) {
            String error = this.error(e);
            Logger.error(error);
            if (this.resolveFailingDependencyArtifact(this.mavenId(error))) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
            try {
                artifacts = this.resolveArtifacts();
            }
            catch (DependencyResolutionException e2) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
        }
        this.removeRunDirectory();
        this.copyToRunDirectory(artifacts);
        this.setRunFile(artifacts);
    }

    void start(int debugPort) throws Exception {
        if (this.process.runFile() == null) {
            this.setRunFile(this.resolveArtifacts());
        }
        Logger.info("Starting process " + this.process.identifier() + (String)(debugPort > 0 ? " with debug port " + debugPort : ""));
        this.systemProcess = this.exec(debugPort);
        this.processLogHandler.log(this.process, this.systemProcess);
        this.process.pid((int)this.systemProcess.toHandle().pid());
        this.process.status(debugPort > 0 ? Process.Status.Debug : Process.Status.Running);
        this.process.save$();
        Logger.info("Process " + this.process.identifier() + " launched with id: " + this.process.pid());
    }

    void stop() {
        if (this.systemProcess == null) {
            return;
        }
        this.systemProcess.children().forEach(ProcessHandle::destroy);
        this.systemProcess.destroy();
        if (this.systemProcess.isAlive()) {
            try {
                Thread.sleep(10000L);
                this.kill();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        this.process.status(Process.Status.Stopped);
    }

    void kill() {
        this.systemProcess.children().forEach(ProcessHandle::destroyForcibly);
        boolean b = this.systemProcess.toHandle().destroyForcibly();
        this.process.status(Process.Status.Stopped);
    }

    boolean isRunning() {
        return this.systemProcess != null && this.systemProcess.toHandle().isAlive();
    }

    int exitValue() {
        return this.systemProcess != null ? this.systemProcess.exitValue() : -1;
    }

    void removeRunDirectory() {
        Utils.removeDirectory(this.appRunDirectory);
    }

    void removeAppHomeDirectory() {
        this.appHomeDirectory.renameTo(new File(this.appHomeDirectory.getParentFile(), this.appHomeDirectory.getName() + "_" + System.currentTimeMillis() / 1000L));
    }

    private boolean resolveFailingDependencyArtifact(String mavenId) {
        if (mavenId == null) {
            return false;
        }
        Logger.info("Resolving failed dependency " + mavenId);
        try {
            return !this.resolveArtifact(new DefaultArtifact(mavenId)).isEmpty();
        }
        catch (DependencyResolutionException e) {
            return false;
        }
    }

    private String mavenId(String error) {
        if (!error.contains(COULD_NOT_FIND_ARTIFACT)) {
            return null;
        }
        String substring = error.substring(error.lastIndexOf(COULD_NOT_FIND_ARTIFACT));
        substring = substring.replace("Could not find artifact ", "");
        return substring.substring(0, substring.indexOf(" ")).trim();
    }

    private void copyToRunDirectory(List<Artifact> artifacts) {
        try {
            this.copy(artifacts.get(0), "");
            if (artifacts.size() > 1) {
                for (Artifact artifact : artifacts.subList(1, artifacts.size())) {
                    if (artifact.getFile().equals(artifacts.get(0).getFile())) continue;
                    this.copy(artifact, this.process.artifact().classpathPrefix());
                }
            }
            this.changePermissionsAndOwnerOfRunDirectory();
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), e);
        }
    }

    private void changePermissionsAndOwnerOfRunDirectory() throws IOException {
        try (Stream<Path> paths = Files.walk(this.appRunDirectory.toPath(), new FileVisitOption[0]);){
            paths.forEach(p -> {
                boolean v = p.toFile().setWritable(true, false);
                if (!v) {
                    Logger.error("impossible change permission");
                }
                this.changeOwner(p.toFile(), this.deployUser, this.deployGroup);
            });
        }
    }

    private void changeOwner(File file, String user, String group) {
        UserPrincipalLookupService lookupService = this.appRunDirectory.toPath().getFileSystem().getUserPrincipalLookupService();
        try {
            Files.setOwner(file.toPath(), lookupService.lookupPrincipalByName(user));
            GroupPrincipal groupPrincipal = lookupService.lookupPrincipalByGroupName(group);
            if (groupPrincipal != null) {
                Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(groupPrincipal);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void setRunFile(List<Artifact> artifacts) {
        this.process.runFile(new File(this.appRunDirectory, artifacts.get(0).getFile().getName()).getPath()).save$();
    }

    private void copy(Artifact artifact, String classpathPrefix) throws IOException {
        File directory = classpathPrefix.isEmpty() ? this.appRunDirectory : new File(this.appRunDirectory, classpathPrefix);
        directory.mkdir();
        Files.copy(artifact.getFile().toPath(), new File(directory, artifact.getFile().getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private Process exec(int debug) throws IOException {
        ArrayList<String> commandParameters = new ArrayList<String>(this.withDeployUser());
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        commandParameters.add(javaBin);
        if (this.process.requiredMemory() > 0) {
            commandParameters.add("-Xms" + this.process.requiredMemory() + "m");
        }
        commandParameters.add("-Dfile.encoding=UTF-8");
        if (debug > 0) {
            commandParameters.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debug);
        }
        if (this.process.managementPort() != 0) {
            this.waitUntilAvailable();
            commandParameters.addAll(this.jmxParameters());
        }
        commandParameters.addAll(Arrays.asList("-jar", this.process.runFile()));
        commandParameters.addAll(this.process.parameterList().stream().map(p -> p.name() + "=" + this.format(p.value())).collect(Collectors.toList()));
        return new ProcessBuilder(commandParameters).redirectErrorStream(true).start();
    }

    private void waitUntilAvailable() {
        try {
            while (!this.isAvailable()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isAvailable() {
        boolean result = true;
        try {
            new Socket(InetAddress.getLocalHost(), this.process.managementPort()).close();
            result = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private List<String> withDeployUser() {
        return Arrays.asList("/usr/bin/sudo", "-u", this.deployUser);
    }

    private String error(DependencyResolutionException e) {
        String stackTrace = ExceptionUtils.getStackTrace(e);
        return Arrays.stream(stackTrace.split("\n")).filter(l -> l.contains(COULD_NOT_FIND_ARTIFACT) || l.contains("Caused by:")).distinct().collect(Collectors.joining("\n"));
    }

    private String format(String value) {
        if (value == null) {
            return "";
        }
        if (value.contains("$HOME")) {
            this.appHomeDirectory.mkdirs();
            this.changeOwner(this.appHomeDirectory, this.deployUser, this.deployGroup);
        }
        return value.replace("$HOME", this.appHomeDirectory.getAbsolutePath());
    }

    private List<Artifact> resolveArtifacts() throws DependencyResolutionException {
        Logger.info("Resolving artifacts of " + this.process.identifier());
        this.deleteMainArtifact(this.localRepository);
        DefaultArtifact artifact = new DefaultArtifact(this.process.artifact().identifier());
        return this.resolveArtifact(artifact);
    }

    private List<Artifact> resolveArtifact(DefaultArtifact artifact) throws DependencyResolutionException {
        LibraryResolver resolver = new LibraryResolver(this.localRepository, this.process.artifact().artifactoryList());
        ArrayList<Artifact> result = new ArrayList<Artifact>(resolver.resolve(artifact, "compile"));
        result.addAll(resolver.resolve(artifact, "runtime"));
        return result;
    }

    private void deleteMainArtifact(File localRepository) {
        try {
            Process.Artifact artifact = this.process.artifact();
            File directory = new File(localRepository, artifact.groupId().replace(".", File.separator) + File.separator + artifact.artifactId() + File.separator + artifact.version());
            FileUtils.deleteDirectory(directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<String> jmxParameters() {
        return Arrays.asList("-Dcom.sun.management.jmxremote", "--add-opens=java.base/java.nio=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "-Djava.rmi.server.hostname=127.0.0.1", "-Dcom.sun.management.jmxremote.port=" + this.process.managementPort(), "-Dcom.sun.management.jmxremote.rmi.port=" + this.process.managementPort(), "-Dcom.sun.management.jmxremote.local.only=true", "-Dcom.sun.management.jmxremote.authenticate=false", "-Dcom.sun.management.jmxremote.ssl=false", "-XX:+StartAttachListener");
    }
}

