/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.ServerBoot;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.ScheduleServerStatusAction;
import io.intino.consul.box.sigar.SigarServerManager;
import io.intino.consul.graph.Info;
import io.intino.consul.graph.Process;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class NotifyBootAction {
    public ConsulBox box;
    public Context context = new Context();

    public void execute() {
        ServerBoot serverBoot = this.serverBoot();
        if (this.box.terminal() != null) {
            this.box.terminal().publish(serverBoot);
        }
        Logger.info("Boot notified");
        if (this.box.graph().info() == null) {
            this.box.graph().create().info(this.box.serverId(), serverBoot.diskSize(), serverBoot.memorySize(), serverBoot.ip(), Info.Scope.valueOf(this.box.configuration().scope().toUpperCase()));
        } else {
            this.box.graph().info().diskSize(serverBoot.diskSize()).memorySize(serverBoot.memorySize()).ip(serverBoot.ip());
        }
        ScheduleServerStatusAction action = new ScheduleServerStatusAction();
        action.box = this.box;
        action.execute();
    }

    private ServerBoot serverBoot() {
        SigarServerManager manager = new SigarServerManager();
        return new ServerBoot().id(this.box.serverId()).scope(this.box.configuration().scope()).version(this.currentVersion()).ts(Instant.now()).ip(this.ip()).architecture(System.getProperty("os.arch")).jvm(System.getProperty("java.version")).os(System.getProperty("os.name")).cores(manager.cores()).deployUser(this.box.deployUser()).diskSize(manager.hddCapacity()).memorySize(manager.memoryCapacity()).maxOpenFiles(manager.maxOpenFiles()).processInfoList(this.infos());
    }

    private List<ServerBoot.ProcessInfo> infos() {
        ArrayList<ServerBoot.ProcessInfo> list = new ArrayList<ServerBoot.ProcessInfo>();
        for (Process process : this.box.graph().processList()) {
            list.add(new ServerBoot.ProcessInfo().id(process.identifier()).artifact(process.artifact().identifier()).jmxPort(process.managementPort()).parameterList(process.parameterList().stream().map(p -> new ServerBoot.ProcessInfo.Parameter().name(p.name()).value(p.value())).collect(Collectors.toList())).classpathPrefix(process.artifact().classpathPrefix()).artifactoryList(process.artifact().artifactoryList().stream().map(a -> new ServerBoot.ProcessInfo.Artifactory().id(a.mavenId()).password(a.password()).url(a.url()).user(a.user())).collect(Collectors.toList())).requiredMemory(process.requiredMemory()));
        }
        return list;
    }

    private String ip() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "0.0.0.0";
        }
    }

    private String currentVersion() {
        try {
            String file = this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
            if (new File(file).isFile()) {
                URL url = new URL("jar:file:" + file + "!/META-INF/MANIFEST.MF");
                Manifest manifest = new Manifest(url.openStream());
                if (manifest.getMainAttributes().getValue("Implementation-Version") == null) {
                    return "1.0.0";
                }
                return manifest.getMainAttributes().getValue("Implementation-Version").trim();
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return "1.0.0";
    }
}

