/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.datahub;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.SessionEvent;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.terminal.Connector;
import io.intino.cesar.datahub.events.ProcessLog;
import io.intino.cesar.datahub.events.ProcessStatus;
import io.intino.cesar.datahub.events.ServerBoot;
import io.intino.cesar.datahub.events.ServerInfo;
import io.intino.cesar.datahub.events.ServerLog;
import io.intino.cesar.datahub.events.ServerStatus;
import java.io.File;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ConsulTerminal {
    private static final Scale scale = Scale.Day;
    private final Connector connector;
    private Map<Consumer<?>, Consumer<Event>> consumers = new HashMap();
    public static String[] subscriptionChannels = new String[0];
    private static final Object monitor = new Object();

    public ConsulTerminal(Connector connector) {
        this.connector = connector;
    }

    public void publish(Object event, String context) {
        if (event instanceof ProcessLog) {
            this.publish((ProcessLog)event);
        }
        if (event instanceof ProcessStatus) {
            this.publish((ProcessStatus)event);
        }
        if (event instanceof ServerBoot) {
            this.publish((ServerBoot)event);
        }
        if (event instanceof ServerInfo) {
            this.publish((ServerInfo)event);
        }
        if (event instanceof ServerLog) {
            this.publish((ServerLog)event);
        }
        if (event instanceof ServerStatus) {
            this.publish((ServerStatus)event);
        }
    }

    public BatchSession batch(File dataHubStageDirectory, File temporalStageDirectory) {
        return new BatchSession(dataHubStageDirectory, temporalStageDirectory);
    }

    public void publish(SessionEvent session) {
        this.connector.sendEvent("Session", session);
    }

    public void subscribe(SessionEventConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new SessionEvent(event.toMessage())));
        this.connector.attachListener("Session", this.consumers.get(onEventReceived));
    }

    public void publish(ProcessLog processLog) {
        this.connector.sendEvent("consul.process.ProcessLog", processLog);
    }

    public void publish(ProcessStatus processStatus) {
        this.connector.sendEvent("consul.process.ProcessStatus", processStatus);
    }

    public void publish(ServerBoot serverBoot) {
        this.connector.sendEvent("consul.server.ServerBoot", serverBoot);
    }

    public void publish(ServerInfo serverInfo) {
        this.connector.sendEvent("consul.server.ServerInfo", serverInfo);
    }

    public void publish(ServerLog serverLog) {
        this.connector.sendEvent("consul.server.ServerLog", serverLog);
    }

    public void publish(ServerStatus serverStatus) {
        this.connector.sendEvent("consul.server.ServerStatus", serverStatus);
    }

    public static interface ServerBootConsumer
    extends Consumer<ServerBoot> {
    }

    public static interface ServerLogConsumer
    extends Consumer<ServerLog> {
    }

    public static interface ServerStatusConsumer
    extends Consumer<ServerStatus> {
    }

    public static interface ServerInfoConsumer
    extends Consumer<ServerInfo> {
    }

    public static interface ProcessLogConsumer
    extends Consumer<ProcessLog> {
    }

    public static interface ProcessStatusConsumer
    extends Consumer<ProcessStatus> {
    }

    public static interface SessionEventConsumer
    extends Consumer<SessionEvent> {
    }

    public class BatchSession {
        private final File dataHubStage;
        private final File temporalStage;
        private final SessionHandler sessionHandler;
        private final EventSession eventSession;

        public BatchSession(File dataHubStage, File temporalStage) {
            this.dataHubStage = dataHubStage;
            this.temporalStage = temporalStage;
            this.sessionHandler = new SessionHandler(temporalStage);
            this.eventSession = this.sessionHandler.createEventSession();
        }

        public void feed(Event event, String context) {
            this.eventSession.put(this.tankOf(event, context), Timetag.of(event.ts(), scale), event);
        }

        public void push() {
            this.eventSession.close();
            this.sessionHandler.pushTo(this.dataHubStage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void seal() {
            Object object = monitor;
            synchronized (object) {
                ConsulTerminal.this.connector.requestResponse("service.ness.seal", new Event(new Message("Seal").set("stage", this.temporalStage.getName())).ts(Instant.now()).toString(), s -> {
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                });
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    Logger.error(e);
                }
            }
        }

        private String tankOf(Event event, String context) {
            if (event instanceof ProcessLog) {
                return "consul.process.ProcessLog";
            }
            if (event instanceof ProcessStatus) {
                return "consul.process.ProcessStatus";
            }
            if (event instanceof ServerBoot) {
                return "consul.server.ServerBoot";
            }
            if (event instanceof ServerInfo) {
                return "consul.server.ServerInfo";
            }
            if (event instanceof ServerLog) {
                return "consul.server.ServerLog";
            }
            if (event instanceof ServerStatus) {
                return "consul.server.ServerStatus";
            }
            return event.toMessage().type();
        }
    }
}

