/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Parser;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

class ParserFactory {
    private static Map<Class<?>, Parser> parsers;
    private static String NullValue;

    ParserFactory() {
    }

    static Parser get(Class<?> class_) {
        return parsers.get(class_);
    }

    static {
        NullValue = "\u0000";
        parsers = new HashMap();
        parsers.put(Boolean.TYPE, Boolean::parseBoolean);
        parsers.put(Byte.TYPE, Byte::parseByte);
        parsers.put(Integer.TYPE, Integer::parseInt);
        parsers.put(Float.TYPE, Float::parseFloat);
        parsers.put(Double.TYPE, Double::parseDouble);
        parsers.put(Long.TYPE, Long::parseLong);
        parsers.put(Boolean.class, parsers.get(Boolean.TYPE));
        parsers.put(Byte.class, parsers.get(Byte.TYPE));
        parsers.put(Integer.class, parsers.get(Integer.TYPE));
        parsers.put(Long.class, parsers.get(Long.TYPE));
        parsers.put(Float.class, parsers.get(Float.TYPE));
        parsers.put(Double.class, parsers.get(Double.TYPE));
        parsers.put(String.class, text -> text);
        parsers.put(Instant.class, Instant::parse);
        parsers.put(Boolean[].class, ArrayParser.of(Boolean.class)::parse);
        parsers.put(Byte[].class, ArrayParser.of(Byte.class)::parse);
        parsers.put(Integer[].class, ArrayParser.of(Integer.class)::parse);
        parsers.put(Float[].class, ArrayParser.of(Float.class)::parse);
        parsers.put(Long[].class, ArrayParser.of(Long.class)::parse);
        parsers.put(Double[].class, ArrayParser.of(Double.class)::parse);
        parsers.put(String[].class, ArrayParser.of(String.class)::parse);
        parsers.put(Instant[].class, ArrayParser.of(Instant.class)::parse);
    }

    static class ArrayParser {
        private Class type;
        private Parser parser;

        ArrayParser(Class type, Parser parser) {
            this.type = type;
            this.parser = parser;
        }

        Object parse(String text) {
            String[] lines = text.split(String.valueOf('\u0001'));
            Object result = Array.newInstance(this.type, lines.length);
            for (int i = 0; i < lines.length; ++i) {
                Array.set(result, i, NullValue.equals(lines[i]) ? null : this.parser.parse(lines[i]));
            }
            return result;
        }

        static ArrayParser of(Class type) {
            return new ArrayParser(type, Parser.of(type));
        }
    }
}

