/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.services.cloudfront.model.Signer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveTrustedSigners
implements Serializable {
    private Boolean enabled;
    private Integer quantity;
    private List<Signer> items;

    public ActiveTrustedSigners() {
    }

    public ActiveTrustedSigners(List<Signer> items) {
        this.items = items;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ActiveTrustedSigners withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public ActiveTrustedSigners withQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public List<Signer> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Signer>();
        }
        return this.items;
    }

    public void setItems(Collection<Signer> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ArrayList<Signer> itemsCopy = new ArrayList<Signer>(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public ActiveTrustedSigners withItems(Signer ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<Signer>(items.length));
        }
        for (Signer value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public ActiveTrustedSigners withItems(Collection<Signer> items) {
        if (items == null) {
            this.items = null;
        } else {
            ArrayList<Signer> itemsCopy = new ArrayList<Signer>(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isEnabled() != null) {
            sb.append("Enabled: " + this.isEnabled() + ",");
        }
        if (this.getQuantity() != null) {
            sb.append("Quantity: " + this.getQuantity() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isEnabled() == null ? 0 : this.isEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveTrustedSigners)) {
            return false;
        }
        ActiveTrustedSigners other = (ActiveTrustedSigners)obj;
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        if (other.isEnabled() != null && !other.isEnabled().equals(this.isEnabled())) {
            return false;
        }
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || ((Object)other.getItems()).equals(this.getItems());
    }
}

