/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import org.sonatype.guice.bean.locators.Implicit;
import org.sonatype.guice.bean.locators.InjectorPublisher;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.reflect.Logs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key<T> implicitKey = Key.get(type.getRawType(), Implicit.class);
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding<?> binding;
            if (!(p instanceof InjectorPublisher) || null == (binding = (i = ((InjectorPublisher)p).getInjector()).getBindings().get(implicitKey))) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, i);
            return binding;
        }
        Key<T> justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorPublisher)) continue;
            Injector i = ((InjectorPublisher)p).getInjector();
            try {
                Binding<T> binding = i.getBinding(justInTimeKey);
                if (!InjectorPublisher.isVisible(binding)) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (RuntimeException e) {
            }
            catch (LinkageError e) {
            }
        }
        return null;
    }
}

