/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.impl.LocalRepositoryEvent;
import org.sonatype.aether.impl.LocalRepositoryMaintainer;
import org.sonatype.aether.impl.RepositoryEventDispatcher;
import org.sonatype.aether.impl.internal.DefaultLocalRepositoryEvent;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=RepositoryEventDispatcher.class)
public class DefaultRepositoryEventDispatcher
implements RepositoryEventDispatcher,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement(role=RepositoryListener.class)
    private List<RepositoryListener> listeners = new ArrayList<RepositoryListener>();
    @Requirement(role=LocalRepositoryMaintainer.class)
    private List<LocalRepositoryMaintainer> localRepositoryMaintainers = new ArrayList<LocalRepositoryMaintainer>();

    public DefaultRepositoryEventDispatcher() {
    }

    public DefaultRepositoryEventDispatcher(Logger logger2, List<RepositoryListener> listeners) {
        this.setLogger(logger2);
        this.setListeners(listeners);
    }

    public DefaultRepositoryEventDispatcher(Logger logger2, List<RepositoryListener> listeners, List<LocalRepositoryMaintainer> localRepositoryMaintainers) {
        this(logger2, listeners);
        this.setLocalRepositoryMaintainers(localRepositoryMaintainers);
    }

    public DefaultRepositoryEventDispatcher setLogger(Logger logger2) {
        this.logger = logger2 != null ? logger2 : NullLogger.INSTANCE;
        return this;
    }

    public DefaultRepositoryEventDispatcher addListener(RepositoryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("repository listener has not been specified");
        }
        this.listeners.add(listener);
        return this;
    }

    public DefaultRepositoryEventDispatcher setListeners(List<RepositoryListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<RepositoryListener>() : listeners;
        return this;
    }

    public DefaultRepositoryEventDispatcher addLocalRepositoryMaintainer(LocalRepositoryMaintainer maintainer) {
        if (maintainer == null) {
            throw new IllegalArgumentException("local repository maintainer has not been specified");
        }
        this.localRepositoryMaintainers.add(maintainer);
        return this;
    }

    public DefaultRepositoryEventDispatcher setLocalRepositoryMaintainers(List<LocalRepositoryMaintainer> maintainers) {
        this.localRepositoryMaintainers = maintainers == null ? new ArrayList<LocalRepositoryMaintainer>() : maintainers;
        return this;
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setListeners(locator.getServices(RepositoryListener.class));
        this.setLocalRepositoryMaintainers(locator.getServices(LocalRepositoryMaintainer.class));
    }

    @Override
    public void dispatch(RepositoryEvent event) {
        RepositoryListener listener;
        if (!this.listeners.isEmpty()) {
            for (RepositoryListener listener2 : this.listeners) {
                this.dispatch(event, listener2);
            }
        }
        if (!this.localRepositoryMaintainers.isEmpty()) {
            DefaultLocalRepositoryEvent evt;
            if (RepositoryEvent.EventType.ARTIFACT_DOWNLOADED.equals((Object)event.getType())) {
                evt = new DefaultLocalRepositoryEvent(LocalRepositoryEvent.EventType.ARTIFACT_DOWNLOADED, event.getSession(), event.getArtifact(), event.getFile());
                for (LocalRepositoryMaintainer maintainer : this.localRepositoryMaintainers) {
                    try {
                        maintainer.artifactDownloaded(evt);
                    }
                    catch (Exception e) {
                        this.logError(e, maintainer);
                    }
                }
            } else if (RepositoryEvent.EventType.ARTIFACT_INSTALLED.equals((Object)event.getType())) {
                evt = new DefaultLocalRepositoryEvent(LocalRepositoryEvent.EventType.ARTIFACT_INSTALLED, event.getSession(), event.getArtifact(), event.getFile());
                for (LocalRepositoryMaintainer maintainer : this.localRepositoryMaintainers) {
                    try {
                        maintainer.artifactInstalled(evt);
                    }
                    catch (Exception e) {
                        this.logError(e, maintainer);
                    }
                }
            }
        }
        if ((listener = event.getSession().getRepositoryListener()) != null) {
            this.dispatch(event, listener);
        }
    }

    private void dispatch(RepositoryEvent event, RepositoryListener listener) {
        try {
            switch (event.getType()) {
                case ARTIFACT_DEPLOYED: {
                    listener.artifactDeployed(event);
                    break;
                }
                case ARTIFACT_DEPLOYING: {
                    listener.artifactDeploying(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_INVALID: {
                    listener.artifactDescriptorInvalid(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_MISSING: {
                    listener.artifactDescriptorMissing(event);
                    break;
                }
                case ARTIFACT_DOWNLOADED: {
                    listener.artifactDownloaded(event);
                    break;
                }
                case ARTIFACT_DOWNLOADING: {
                    listener.artifactDownloading(event);
                    break;
                }
                case ARTIFACT_INSTALLED: {
                    listener.artifactInstalled(event);
                    break;
                }
                case ARTIFACT_INSTALLING: {
                    listener.artifactInstalling(event);
                    break;
                }
                case ARTIFACT_RESOLVED: {
                    listener.artifactResolved(event);
                    break;
                }
                case ARTIFACT_RESOLVING: {
                    listener.artifactResolving(event);
                    break;
                }
                case METADATA_DEPLOYED: {
                    listener.metadataDeployed(event);
                    break;
                }
                case METADATA_DEPLOYING: {
                    listener.metadataDeploying(event);
                    break;
                }
                case METADATA_DOWNLOADED: {
                    listener.metadataDownloaded(event);
                    break;
                }
                case METADATA_DOWNLOADING: {
                    listener.metadataDownloading(event);
                    break;
                }
                case METADATA_INSTALLED: {
                    listener.metadataInstalled(event);
                    break;
                }
                case METADATA_INSTALLING: {
                    listener.metadataInstalling(event);
                    break;
                }
                case METADATA_INVALID: {
                    listener.metadataInvalid(event);
                    break;
                }
                case METADATA_RESOLVED: {
                    listener.metadataResolved(event);
                    break;
                }
                case METADATA_RESOLVING: {
                    listener.metadataResolving(event);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown repository event type " + (Object)((Object)event.getType()));
                }
            }
        }
        catch (Exception e) {
            this.logError(e, listener);
        }
        catch (LinkageError e) {
            this.logError(e, listener);
        }
    }

    private void logError(Throwable e, Object listener) {
        String msg = "Failed to dispatch repository event to " + listener.getClass().getCanonicalName() + ": " + e.getMessage();
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(msg, e);
        } else {
            this.logger.warn(msg);
        }
    }
}

