/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.async;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.connector.async.AsyncRepositoryConnector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;

@Component(role=RepositoryConnectorFactory.class, hint="async-http")
public class AsyncRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileProcessor fileProcessor;
    private int priority = 100;

    public AsyncRepositoryConnectorFactory() {
    }

    public AsyncRepositoryConnectorFactory(Logger logger2, FileProcessor fileProcessor) {
        this.setLogger(logger2);
        this.setFileProcessor(fileProcessor);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
    }

    public AsyncRepositoryConnectorFactory setLogger(Logger logger2) {
        this.logger = logger2 != null ? logger2 : NullLogger.INSTANCE;
        return this;
    }

    public AsyncRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public AsyncRepositoryConnectorFactory setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        return new AsyncRepositoryConnector(repository, session, this.fileProcessor, this.logger);
    }
}

