/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class ProxyList<T, E extends T>
implements List<E> {
    private final List<T> list;
    private final Class<E> aClass;

    public ProxyList(List<T> list, Class<E> aClass) {
        this.list = list;
        this.aClass = aClass;
    }

    @Override
    public int size() {
        return this.filteredList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.filteredList().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.filteredList().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.filteredList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.filteredList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.filteredList().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.filteredList().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.list.addAll(this.list.indexOf(this.filteredList().get(index)), c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.removeIf(this.aClass::isInstance);
    }

    @Override
    public E get(int index) {
        return this.filteredList().get(index);
    }

    @Override
    public E set(int index, E element) {
        E removed = this.filteredList().get(index);
        this.list.set(this.list.indexOf(removed), element);
        return removed;
    }

    @Override
    public void add(int index, E element) {
        this.list.add(this.list.indexOf(this.filteredList().get(index)), element);
    }

    @Override
    public E remove(int index) {
        E element = this.filteredList().get(index);
        this.list.remove(element);
        return element;
    }

    @Override
    public int indexOf(Object o) {
        return this.filteredList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.filteredList().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return Collections.unmodifiableList(this.filteredList()).listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return Collections.unmodifiableList(this.filteredList()).listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.filteredList().subList(fromIndex, toIndex));
    }

    private List<E> filteredList() {
        return this.list.stream().filter(this.aClass::isInstance).map(e -> e).collect(Collectors.toList());
    }
}

