/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Predicate {
    protected final String id;
    final Set<String> typeNames = new LinkedHashSet<String>();

    Predicate(String id) {
        this.id = id;
    }

    public static String nameOf(String id) {
        String shortName = id.contains(".") ? id.substring(id.lastIndexOf(".") + 1) : id;
        shortName = shortName.contains("#") ? shortName.substring(shortName.lastIndexOf("#") + 1) : shortName;
        shortName = shortName.contains("$") ? shortName.substring(shortName.lastIndexOf("$") + 1) : shortName;
        return shortName;
    }

    public String rootNodeId() {
        int pos = this.id.indexOf("$");
        return pos != -1 ? this.id.substring(0, pos) : this.id;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return Predicate.nameOf(this.id);
    }

    public abstract List<Concept> conceptList();

    void putType(Concept concept) {
        this.typeNames.add(concept.id);
    }

    public abstract List<Node> componentList();

    public abstract Map<String, List<?>> variables();

    public abstract <T extends Layer> List<T> findNode(Class<T> var1);
}

