/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.graph;

import io.intino.consul.graph.Info;
import io.intino.consul.graph.Process;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Process> processList = new ArrayList<Process>();
    private Info info;
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("consul");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("consul");
        this.processList = new ArrayList<Process>(wrapper.processList);
        this.info = wrapper.info;
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return this.core$().as(t);
    }

    @Override
    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    @Override
    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Process> processList() {
        return this.processList;
    }

    public Info info() {
        return this.info;
    }

    public Stream<Process> processList(Predicate<Process> filter) {
        return this.processList.stream().filter(filter);
    }

    public Process process(int index) {
        return this.processList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Process", new Indexer(node -> this.processList.add(node.as(Process.class)), node -> this.processList.remove(node.as(Process.class)), () -> this.processList.clear()));
        map.put("Info", new Indexer(node -> {
            this.info = node.as(Info.class);
        }, node -> {
            this.info = null;
        }, () -> {
            this.info = null;
        }));
        return map;
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
        public void process(Predicate<Process> filter) {
            new ArrayList<Process>(AbstractGraph.this.processList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Process process(String identifier, String workspace, int managementPort) {
            Process newElement = AbstractGraph.this.graph.createRoot(Process.class, this.stash, this.name).a$(Process.class);
            newElement.core$().set(newElement, "identifier", Collections.singletonList(identifier));
            newElement.core$().set(newElement, "workspace", Collections.singletonList(workspace));
            newElement.core$().set(newElement, "managementPort", Collections.singletonList(managementPort));
            return newElement;
        }

        public Info info(long diskSize, double memorySize, String ip) {
            Info newElement = AbstractGraph.this.graph.createRoot(Info.class, this.stash, this.name).a$(Info.class);
            newElement.core$().set(newElement, "diskSize", Collections.singletonList(diskSize));
            newElement.core$().set(newElement, "memorySize", Collections.singletonList(memorySize));
            newElement.core$().set(newElement, "ip", Collections.singletonList(ip));
            return newElement;
        }
    }
}

