/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.intino.alexandria.Json;
import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.ParameterAction;

public class ParameterRequest
implements EventHub.RequestConsumer {
    private ConsulBox box;

    public ParameterRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String accept(String request) {
        try {
            JsonObject jsonObject = new Gson().fromJson(request, JsonObject.class);
            return Json.toString(this.actionFor(this.parameter(jsonObject, "processId"), this.parameter(jsonObject, "name"), this.parameter(jsonObject, "value")).execute());
        }
        catch (Throwable e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String parameter(JsonObject jsonObject, String parameter) {
        return jsonObject.get(parameter).getAsString();
    }

    private ParameterAction actionFor(String processId, String name, String value) {
        ParameterAction action = new ParameterAction();
        action.box = this.box;
        action.processId = processId;
        action.name = name;
        action.value = value;
        return action;
    }
}

