/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.intino.alexandria.Json;
import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.DebugProcessAction;

public class DebugProcessRequest
implements EventHub.RequestConsumer {
    private ConsulBox box;

    public DebugProcessRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String accept(String request) {
        try {
            JsonObject jsonObject = new Gson().fromJson(request, JsonObject.class);
            return Json.toString(this.actionFor(this.parameter(jsonObject, "processId"), Integer.parseInt(this.parameter(jsonObject, "port"))).execute());
        }
        catch (Throwable e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String parameter(JsonObject jsonObject, String parameter) {
        return jsonObject.get(parameter).getAsString();
    }

    private DebugProcessAction actionFor(String processId, Integer port) {
        DebugProcessAction action = new DebugProcessAction();
        action.box = this.box;
        action.processId = processId;
        action.port = port;
        return action;
    }
}

