/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ArtifactoryConnector;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.LibraryResolver;
import io.intino.consul.graph.Process;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class UpgradeAction {
    public ConsulBox box;

    public Boolean execute() {
        List<Artifact> artifacts;
        ArtifactoryConnector.Version lastVersion = this.lastVersion();
        Logger.info("Upgrading consul to " + lastVersion.get());
        if (this.box.graph() != null) {
            for (Process process : this.box.graph().processList()) {
                this.box.processManager().kill(process);
            }
        }
        if ((artifacts = this.downloadNewVersion(lastVersion)).isEmpty()) {
            return false;
        }
        this.replaceJar(artifacts);
        this.restartConsul();
        return true;
    }

    private void replaceJar(List<Artifact> artifacts) {
        File jarFile = new File(this.getJarPath());
        try {
            Files.copy(artifacts.get(0).getFile().toPath(), jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), e);
        }
    }

    private List<Artifact> downloadNewVersion(ArtifactoryConnector.Version version) {
        try {
            this.clearLocalRepositoryVersion(version);
            File localRepository = new File(System.getProperty("user.home"), ".m2" + File.separator + "repository");
            LibraryResolver aether = new LibraryResolver(localRepository, "intino-maven", "default", "https://artifactory.intino.io/artifactory/releases");
            return aether.resolve(new DefaultArtifact("io.intino:consul:" + version), "compile");
        }
        catch (DependencyResolutionException e) {
            Logger.error(e);
            return Collections.emptyList();
        }
    }

    private void clearLocalRepositoryVersion(ArtifactoryConnector.Version version) {
        File repo = new File(System.getProperty("user.home"), ".m2" + File.separator + "repository");
        File file = new File(repo, "io" + File.separator + "intino" + File.separator + "consul" + File.separator + version.get());
        try {
            if (file.exists()) {
                FileUtils.deleteDirectory(file);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void restartConsul() {
        Logger.warn("Trying to restart application");
        new Thread(() -> {
            Logger.warn("Shutdown application. PID: " + ManagementFactory.getRuntimeMXBean().getName());
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
            executorService.schedule(this::restart, 5L, TimeUnit.SECONDS);
        }).start();
    }

    private void restart() {
        try {
            new ProcessBuilder("service", "consul", "restart").redirectErrorStream(true).start();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private String getJarPath() {
        return UpgradeAction.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    }

    private ArtifactoryConnector.Version lastVersion() {
        List<String> versions = new ArtifactoryConnector().consulVersions();
        versions.sort(String::compareTo);
        return new ArtifactoryConnector.Version(versions.get(versions.size() - 1));
    }
}

