/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.schemas.ServerStatus;
import io.intino.consul.sigar.SigarServerManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;

public class StatusAction {
    public ConsulBox box;

    public ServerStatus execute() {
        try {
            SigarServerManager manager = new SigarServerManager();
            return new ServerStatus().ts(Instant.now()).id(this.box.serverId()).memory(manager.usedMemoryPercent()).cpu(manager.usedCPUUsagePercent()).hdd(manager.usedHDDUsagePercent()).kernelTemperature(this.isTemperatureAvailable() ? (double)this.readTemperature() : 0.0).inboundConnections(manager.inboundConnections()).outboundConnections(manager.outboundConnections());
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    private boolean isTemperatureAvailable() {
        return new File("/opt/vc/bin/vcgencmd").exists();
    }

    private float readTemperature() {
        try {
            Process p = Runtime.getRuntime().exec("/opt/vc/bin/vcgencmd measure_temp");
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = br.readLine();
            if (s != null) {
                return Float.parseFloat(s.replace("temp=", "").replace("'C", ""));
            }
            p.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0f;
    }
}

