/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.message.MessageBuilder;
import io.intino.alexandria.rest.spark.SparkContext;
import io.intino.consul.Channels;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.actions.ProcessStatusAction;
import io.intino.consul.box.actions.RestartProcessAction;
import io.intino.consul.box.actions.StartProcessAction;
import io.intino.consul.box.actions.StopProcessAction;
import io.intino.consul.graph.Process;
import java.util.stream.Collectors;

public class PostChangeProcessStatusAction {
    public ConsulBox box;
    public SparkContext context;
    public String process;
    public String status;
    public Boolean debugging;

    public Boolean execute() throws BadRequest {
        Process process = ProcessFinder.processFromShortName(this.box.graph(), this.process);
        if (process == null) {
            process = ProcessFinder.processFromIdentifier(this.box.graph(), this.process.replace(":", "_"));
        }
        if (process == null) {
            throw new BadRequest("Process " + this.process + " not Found. Registered processes: " + this.box.graph().processList().stream().map(Process::shortName).collect(Collectors.joining(", ")));
        }
        Boolean execute = this.status.equals("start") ? new StartProcessAction(this.box, process.identifier()).execute() : (this.status.equals("restart") ? new RestartProcessAction(this.box, process.identifier()).execute() : new StopProcessAction(this.box, process.identifier()).execute());
        this.box.eventHub().sendEvent(Channels.serverStatus, new Event(MessageBuilder.toMessage(new ProcessStatusAction(this.box, process.identifier()).execute())));
        return execute;
    }
}

