/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.schemas.DeployResult;
import io.intino.consul.box.schemas.ProcessSchema;
import io.intino.consul.graph.Process;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DeployAction {
    public ProcessSchema process;
    public ConsulBox box;
    private static AtomicBoolean isDeploying = new AtomicBoolean(false);

    public synchronized DeployResult execute() {
        try {
            DeployResult result;
            if (isDeploying.get()) {
                this.wait();
            }
            isDeploying.set(true);
            Logger.info("Deploying " + this.process.artifact() + "...");
            Process oldProcess = ProcessFinder.processFromIdentifier(this.box.graph(), this.process.name());
            Process newProcess = this.createProcess();
            if (oldProcess != null) {
                this.box.processManager().stop(oldProcess);
            }
            if ((result = this.box.processManager().deploy(newProcess)).success().booleanValue()) {
                newProcess.save$();
                if (oldProcess != null) {
                    oldProcess.delete$();
                }
            } else {
                newProcess.delete$();
            }
            isDeploying.set(false);
            this.notify();
            return result;
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            return new DeployResult().success(false).remarks(e.getMessage());
        }
    }

    private Process createProcess() {
        File workspace = new File(this.box.applicationsWorkspace(), this.process.name().replace(":", "_"));
        Process processModel = this.box.graph().create(this.stashName()).process(this.process.name(), workspace.getAbsolutePath(), this.newJMXPort());
        String[] id = this.process.artifact().split(":");
        Process.Artifact artifact = processModel.create().artifact(id[0], id[1], id[2]);
        if (this.process.classpathPrefix() != null) {
            processModel.artifact().classpathPrefix(this.process.classpathPrefix());
        }
        processModel.requiredMemory(this.process.requiredMemory());
        this.addArtifactories(artifact);
        this.addParameters(processModel);
        processModel.save$();
        return processModel;
    }

    private int newJMXPort() {
        List usedPorts = this.box.graph().processList().stream().map(Process::managementPort).collect(Collectors.toList());
        return IntStream.range(10001, 11000).filter(p -> !usedPorts.contains(p)).findFirst().orElse(11000);
    }

    private String stashName() {
        return "processes/" + this.process.name().replace(":", "_").replace(".", "_");
    }

    private void addArtifactories(Process.Artifact artifact) {
        this.process.artifactories().forEach(artifactory -> artifact.create().artifactory(artifactory.url(), artifactory.id(), artifactory.user(), artifactory.password()));
    }

    private void addParameters(Process process) {
        new ArrayList<Process.Parameter>(process.parameterList()).forEach(Layer::delete$);
        this.process.parameterList().forEach(parameter -> process.create().parameter(parameter.name(), parameter.value()));
    }
}

