/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.message.MessageBuilder;
import io.intino.consul.Channels;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.schemas.ServerInfo;
import io.intino.consul.graph.Info;
import io.intino.consul.sigar.SigarServerManager;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.time.Instant;

public class CheckServerInfoChangesAction {
    public ConsulBox box;
    public Context context = new Context();

    public void execute() {
        ServerInfo serverInfo = this.serverInfo();
        if (!this.hasChanges(serverInfo)) {
            return;
        }
        EventHub messageHub = this.box.eventHub();
        if (messageHub != null) {
            messageHub.sendEvent(Channels.serverInfo, new Event(MessageBuilder.toMessage(serverInfo)));
        }
        if (this.box.graph().info() == null) {
            this.box.graph().create().info(serverInfo.diskSize(), serverInfo.memorySize(), serverInfo.ip());
        } else {
            this.box.graph().info().diskSize(serverInfo.diskSize()).memorySize(serverInfo.memorySize()).ip(serverInfo.ip());
        }
    }

    private boolean hasChanges(ServerInfo serverInfo) {
        Info info = this.box.graph().info();
        return info == null || info.diskSize() != serverInfo.diskSize().longValue() || info.memorySize() != serverInfo.memorySize() || !info.ip().equals(serverInfo.ip());
    }

    private ServerInfo serverInfo() {
        SigarServerManager manager = new SigarServerManager();
        return (ServerInfo)new ServerInfo().id(this.box.serverId()).ts(Instant.now()).ip(this.ip()).os(System.getProperty("os.name")).diskSize(manager.hddCapacity()).memorySize(manager.memoryCapacity());
    }

    private String ip() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "0.0.0.0";
        }
    }
}

