/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Store;
import io.intino.tara.magritte.stores.InMemoryFileStore;
import java.io.File;
import org.apache.log4j.Level;

public class Main {
    public static void main(String[] args) {
        ConsulConfiguration configuration = new ConsulConfiguration(args);
        ConsulBox box = (ConsulBox)new ConsulBox(configuration).put(Main.loadGraph(configuration)).open();
        if (box.eventHub() == null) {
            Logger.error("Event Hub couldn't init");
        }
        io.intino.alexandria.logger4j.Logger.setLevel(Level.ERROR);
        Runtime.getRuntime().addShutdownHook(new Thread(box::close));
    }

    private static Graph loadGraph(ConsulConfiguration configuration) {
        return new Graph(Main.store(configuration)).loadStashes("Consul");
    }

    private static Store store(ConsulConfiguration configuration) {
        return new InMemoryFileStore(new File(configuration.get("workspace"))){

            @Override
            public void writeStash(Stash stash, String path) {
                stash.language = stash.language == null || stash.language.isEmpty() ? "Consul" : stash.language;
                super.writeStash(stash, path);
            }
        };
    }
}

