/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.event.JmsEventHub;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.consul.Channels;
import io.intino.consul.box.AbstractBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.service.ConsulJmsService;
import io.intino.consul.graph.ConsulGraph;
import io.intino.consul.graph.Process;
import io.intino.consul.process.ProcessLogHandler;
import io.intino.consul.process.ProcessManager;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.stores.FileSystemStore;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ConsulBox
extends AbstractBox {
    private JmsEventHub eventHub;
    private ConsulJmsService jmsService;
    private ConsulGraph graph;
    private ProcessManager processManager;
    private File applicationsDirectory;
    private ProcessLogHandler processLogHandler;
    private File applicationsWorkspace;
    private String project;
    private String serverId = this.calculateServerId();
    private File logsDirectory;

    public ConsulBox(String[] args) {
        super(args);
        this.init();
    }

    public ConsulBox(ConsulConfiguration configuration) {
        super(configuration);
        this.eventHub = new JmsEventHub(this.configuration().cesarBus(), this.configuration().busUser(), this.configuration().busPassword(), this.configuration().busClientId(), new File(configuration.workspace(), "outbox"));
        this.init();
        this.jmsService = new ConsulJmsService(this.eventHub, this);
    }

    private void init() {
        if (this.configuration.args().containsKey("logsDirectory")) {
            this.logsDirectory = new File(this.configuration.args().get("logsDirectory"));
        }
        this.applicationsDirectory = new File(this.configuration.args().get("applications_directory"));
        this.applicationsWorkspace = new File(this.configuration.args().getOrDefault("applications_workspace", "/home/" + this.deployUser()));
        this.project = this.configuration.args().getOrDefault("project", "sandbox");
        this.processManager = new ProcessManager(this);
    }

    @Override
    public Box put(Object o) {
        if (o instanceof Graph) {
            this.graph = ((Graph)o).as(ConsulGraph.class);
            if (this.logsDirectory == null) {
                this.logsDirectory = ((FileSystemStore)this.graph().core$().store()).directory();
            }
        }
        super.put(o);
        return this;
    }

    @Override
    public Box open() {
        super.open();
        this.processLogHandler = new ProcessLogHandler(this.serverId(), this.logsDirectory, this.eventHub());
        this.configureLogger();
        return this;
    }

    public EventHub eventHub() {
        return this.eventHub;
    }

    @Override
    public void close() {
        super.close();
        Logger.info("Shutting down consul");
        for (Process process : this.graph().processList()) {
            this.processManager.stop(process);
        }
    }

    public ConsulGraph graph() {
        return this.graph;
    }

    public ProcessManager processManager() {
        return this.processManager;
    }

    public void processManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public String project() {
        return this.project;
    }

    public File applicationsDirectory() {
        return this.applicationsDirectory;
    }

    public File applicationsWorkspace() {
        return this.applicationsWorkspace;
    }

    public String serverId() {
        return this.serverId;
    }

    public String deployUser() {
        return this.configuration.deployUser();
    }

    public String deployGroup() {
        return this.configuration.deployGroup();
    }

    public ProcessLogHandler logHandler() {
        return this.processLogHandler;
    }

    private void configureLogger() {
        Logger.addErrorHandler(new ServerLogHandler(this.eventHub()));
        Logger.addErrorHandler(new ServerLogHandler(this.eventHub()));
    }

    private String calculateServerId() {
        try {
            return InetAddress.getLocalHost().getHostName().replace(".", "-");
        }
        catch (UnknownHostException e) {
            Logger.error(e.getMessage());
            return "consul-default-server";
        }
    }

    private static class ServerLogHandler
    implements Logger.LogHandler {
        private final EventHub eventHub;

        ServerLogHandler(EventHub eventHub) {
            this.eventHub = eventHub;
        }

        @Override
        public void publish(String message) {
            this.eventHub.sendEvent(Channels.serverLog, new Event(new MessageReader(message).next()));
        }
    }
}

