/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.rest.AlexandriaSparkBuilder;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.ConsulRestService;
import io.intino.consul.box.Sentinels;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected ConsulConfiguration configuration;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public AbstractBox(String[] args) {
        this(new ConsulConfiguration(args));
    }

    public AbstractBox(ConsulConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
        AlexandriaSparkBuilder.setup(Integer.parseInt("15000"), "www/");
    }

    @Override
    public ConsulConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    @Override
    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initUI();
        this.initRESTServices();
        this.initJMXServices();
        this.initDatalake();
        this.initMessageHub();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        return this;
    }

    @Override
    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
        AlexandriaSparkBuilder.instance().stop();
    }

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    private void initRESTServices() {
        ConsulRestService.setup(AlexandriaSparkBuilder.instance(), (ConsulBox)this).start();
        io.intino.alexandria.logger.Logger.info("REST service consul-rest: started!");
    }

    private void initMessagingServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    private void initDatalake() {
    }

    private void initMessageHub() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
        Sentinels.init(this.scheduler, (ConsulBox)this);
    }

    private void initWorkflow() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter(new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    private URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

