/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.scheduler;

import io.intino.alexandria.scheduler.directory.DirectorySentinel;
import io.intino.alexandria.scheduler.directory.DirectoryTask;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class AlexandriaScheduler {
    private Scheduler scheduler;
    private Map<String, DirectorySentinel> sentinels = new HashMap<String, DirectorySentinel>();

    public AlexandriaScheduler() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public void startSchedules() throws SchedulerException {
        this.scheduler.start();
    }

    public void shutdownSchedules() throws SchedulerException {
        this.scheduler.shutdown();
    }

    public boolean isSchedulerShutdown() throws SchedulerException {
        return this.scheduler.isShutdown();
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        return this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void scheduleJob(JobDetail jobDetail, Set<? extends Trigger> triggersForJob, boolean replace) throws SchedulerException {
        this.scheduler.scheduleJob(jobDetail, triggersForJob, replace);
    }

    public void watchDirectory(String name, File directory, DirectoryTask task, DirectorySentinel.Event ... events) throws SchedulerException {
        DirectorySentinel sentinel = new DirectorySentinel(directory, task, events);
        this.sentinels.put(name, sentinel);
        sentinel.watch();
    }

    public void stopSentinel(String name) {
        this.sentinels.get(name).stop();
    }
}

