/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.rest.spark;

import com.google.gson.GsonBuilder;
import io.intino.alexandria.logger.Logger;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class RequestAdapter {
    public static <T> T adapt(String object, Class<T> type) {
        T result = RequestAdapter.adaptPrimitive(object, type);
        return result != null ? result : RequestAdapter.adaptFromJSON(object, type);
    }

    public static <T> T adaptFromJSON(String object, Class<T> type) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Instant.class), (json, type1, jsonDeserializationContext) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter((Type)((Object)Date.class), (json, type1, jsonDeserializationContext) -> new Date(json.getAsJsonPrimitive().getAsLong()));
        return object == null || object.isEmpty() ? null : (T)builder.create().fromJson(RequestAdapter.decode(object), type);
    }

    public static <T> T adaptFromJSON(String object, Type type) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Instant.class), (json, type1, jsonDeserializationContext) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter((Type)((Object)Date.class), (json, type1, jsonDeserializationContext) -> new Date(json.getAsJsonPrimitive().getAsLong()));
        return object == null || object.isEmpty() ? null : (T)builder.create().fromJson(RequestAdapter.decode(object), type);
    }

    private static String decode(String object) {
        try {
            return URLDecoder.decode(object, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
            return null;
        }
        catch (IllegalArgumentException ex) {
            return object;
        }
    }

    private static <T> T adaptPrimitive(String object, Class<T> type) {
        if (type == String.class) {
            return (T)object;
        }
        if (type == Double.class) {
            return (T)Double.valueOf(object);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(object);
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(object);
        }
        if (type == Instant.class) {
            return (T)Instant.ofEpochMilli(Long.valueOf(object));
        }
        if (type == LocalDate.class) {
            return (T)LocalDate.ofEpochDay(Long.valueOf(object));
        }
        if (type == LocalDateTime.class) {
            return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(object)), ZoneId.of("UTC"));
        }
        return null;
    }
}

