/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.rest.spark;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.rest.spark.PushService;
import io.intino.alexandria.rest.spark.SparkClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class PushServiceHandler {
    private static PushService pushService;
    private Map<String, SparkClient> clientsMap = new HashMap<String, SparkClient>();
    private Map<String, Timer> closeTimersMap = new HashMap<String, Timer>();
    private static final int CloseTimeout = 86400000;
    private static final int CloseGoingAway = 1001;
    private static final int CloseReadEOF = 1006;

    public static void inject(io.intino.alexandria.rest.pushservice.PushService pushService) {
        PushServiceHandler.pushService = (PushService)pushService;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) throws Exception {
        if (this.client(session) != null) {
            this.cancelClose(session);
            this.client(session).session(session);
        } else {
            this.registerClient(session);
        }
        pushService.onOpen(this.client(session));
    }

    @OnWebSocketError
    public void onError(Throwable error) {
        Logger.debug(error.getMessage());
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        String sessionId = SparkClient.sessionId(session);
        this.cancelClose(session);
        if (statusCode == 1001) {
            Logger.debug(String.format("WebSocket connection lost. Status code: %d. %s", statusCode, reason));
            this.doClose(sessionId, this.client(session));
            return;
        }
        this.doCloseDelayed(session, sessionId);
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) {
        if (this.client(session) == null) {
            try {
                session.disconnect();
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
        pushService.onMessage(this.client(session), message);
    }

    protected SparkClient client(Session session) {
        String sessionId = this.id(session);
        return this.clientsMap.get(sessionId);
    }

    protected SparkClient registerClient(Session session) {
        String sessionId = this.id(session);
        SparkClient client = (SparkClient)pushService.createClient(session);
        this.clientsMap.put(sessionId, client);
        return client;
    }

    private String id(Session session) {
        return SparkClient.sessionId(session);
    }

    private void cancelClose(Session session) {
        String sessionId = this.id(session);
        if (!this.closeTimersMap.containsKey(sessionId)) {
            return;
        }
        this.closeTimersMap.get(sessionId).cancel();
        this.closeTimersMap.remove(sessionId);
    }

    private void doCloseDelayed(Session session, final String sessionId) {
        final SparkClient client = this.client(session);
        Timer timer = new Timer("Push service delayed close");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PushServiceHandler.this.doClose(sessionId, client);
            }
        }, 86400000L);
        this.closeTimersMap.put(sessionId, timer);
    }

    private void doClose(String sessionId, SparkClient client) {
        if (client != null) {
            pushService.onClose(client);
        }
        this.clientsMap.remove(sessionId);
        if (!this.closeTimersMap.containsKey(sessionId)) {
            return;
        }
        this.closeTimersMap.get(sessionId).cancel();
        this.closeTimersMap.remove(sessionId);
    }

    private void refreshSession(Session session) {
        SparkClient client = this.registerClient(session);
        client.session(session);
        pushService.linkToThread(client);
    }
}

