/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.rest.pushservice;

import io.intino.alexandria.rest.pushservice.Client;
import io.intino.alexandria.rest.pushservice.Message;
import io.intino.alexandria.rest.pushservice.PushService;
import io.intino.alexandria.rest.pushservice.Session;
import java.util.Collections;
import java.util.Map;

public class MessageCarrier {
    private final Session session;
    private final Client client;
    private final PushService service;

    public MessageCarrier(PushService service, Session session, Client client) {
        this.session = session;
        this.client = client;
        this.service = service;
    }

    public void notifyAll(String message, Map<String, Object> parameters) {
        this.service.pushBroadcast(new Message(message, parameters));
    }

    public void notifyAll(String message) {
        this.notifyAll(message, Collections.emptyMap());
    }

    public void notifyAll(String message, Object parameterValue) {
        this.notifyAll(message, Collections.singletonMap(message, parameterValue));
    }

    public void notifyAll(String message, String parameter, Object parameterValue) {
        this.notifyAll(message, Collections.singletonMap(parameter, parameterValue));
    }

    public void notifySession(String message, Map<String, Object> parameters) {
        this.service.pushToSession(this.session, new Message(message, parameters));
    }

    public void notifySession(String message) {
        this.notifySession(message, Collections.emptyMap());
    }

    public void notifySession(String message, Object parameterValue) {
        this.notifySession(message, Collections.singletonMap(message, parameterValue));
    }

    public void notifySession(String message, String parameter, Object parameterValue) {
        this.notifySession(message, Collections.singletonMap(parameter, parameterValue));
    }

    public void notifyClient(String message, Map<String, Object> parameters) {
        this.service.pushToClient(this.client, new Message(message, parameters));
    }

    public void notifyClient(String message) {
        this.notifyClient(message, Collections.emptyMap());
    }

    public void notifyClient(String message, Object parameterValue) {
        this.notifyClient(message, Collections.singletonMap(message, parameterValue));
    }

    public void notifyClient(String message, String parameter, Object parameterValue) {
        this.notifyClient(message, Collections.singletonMap(parameter, parameterValue));
    }
}

