/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Map;

public class MessageWriter
implements AutoCloseable {
    private final OutputStream os;

    public MessageWriter(OutputStream os) {
        this.os = new BufferedOutputStream(os);
    }

    public void write(Message message) throws IOException {
        this.write(message.toString());
        if (message.hasAttachments()) {
            this.write(message.allAttachments());
        } else {
            this.write("\n");
        }
        this.write("\n");
    }

    private void write(Map<String, byte[]> attachments) throws IOException {
        for (Map.Entry<String, byte[]> entry : attachments.entrySet()) {
            this.write(entry.getKey(), Base64.getEncoder().encode(entry.getValue()));
        }
    }

    private void write(String key, byte[] encode) throws IOException {
        this.os.write(key.getBytes());
        this.os.write(58);
        this.os.write(String.valueOf(encode.length).getBytes());
        this.os.write(10);
        this.os.write(encode);
        this.os.write(10);
        this.os.write(10);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    private void write(String str) throws IOException {
        this.os.write(str.getBytes());
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

