/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import io.intino.alexandria.jms.JmsConsumer;
import io.intino.alexandria.logger.Logger;
import java.util.function.Consumer;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;

public class TopicConsumer
extends JmsConsumer {
    private String subscriberId = null;

    public TopicConsumer(Session session, String topic) throws JMSException {
        super(session, session.createTopic(topic));
    }

    public void listen(Consumer<Message> listener, String subscriberId) {
        try {
            this.listeners.add(listener);
            this.subscriberId = subscriberId;
            if (this.consumer == null) {
                this.consumer = this.session.createDurableSubscriber((Topic)this.destination, subscriberId, null, true);
                this.consumer.setMessageListener(m -> this.listeners.forEach(l -> l.accept(m)));
            }
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.consumer == null) {
                return;
            }
            this.consumer.close();
            if (this.subscriberId != null) {
                this.session.unsubscribe(this.subscriberId);
            }
        }
        catch (InvalidDestinationException invalidDestinationException) {
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }
}

