/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import io.intino.alexandria.logger.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

public abstract class JmsProducer {
    protected final Session session;
    private MessageProducer producer = null;

    public JmsProducer(Session session, Destination destination) {
        this(session, destination, 0);
    }

    public JmsProducer(Session session, Destination destination, int messageExpirationSeconds) {
        this.session = session;
        try {
            this.producer = session.createProducer(destination);
            this.producer.setTimeToLive(messageExpirationSeconds * 1000);
            this.producer.setDeliveryMode(1);
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    public boolean produce(Message message) {
        try {
            this.producer.send(message);
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public boolean produce(Message message, int messageExpirationSeconds) {
        try {
            this.producer.send(message, 1, 4, messageExpirationSeconds * 1000);
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    public void close() {
        if (this.producer != null) {
            try {
                this.producer.close();
                this.producer = null;
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }
}

