/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.IConnectionCustomizer;
import com.zaxxer.hikari.metrics.CodaHaleMetricsTracker;
import com.zaxxer.hikari.metrics.CodahaleHealthChecker;
import com.zaxxer.hikari.metrics.MetricsTracker;
import com.zaxxer.hikari.pool.GlobalPoolLock;
import com.zaxxer.hikari.pool.HikariMBeanElf;
import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.pool.HikariPoolMXBean;
import com.zaxxer.hikari.pool.LeakTask;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.pool.PoolInitializationException;
import com.zaxxer.hikari.pool.PoolUtilities;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.ConcurrentBag;
import com.zaxxer.hikari.util.DefaultThreadFactory;
import com.zaxxer.hikari.util.IBagStateListener;
import com.zaxxer.hikari.util.UtilityElf;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHikariPool
implements HikariPoolMXBean,
IBagStateListener {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final long ALIVE_BYPASS_WINDOW = Long.getLong("com.zaxxer.hikari.aliveBypassWindow", 1000L);
    protected static final int POOL_RUNNING = 0;
    protected static final int POOL_SUSPENDED = 1;
    protected static final int POOL_SHUTDOWN = 2;
    public final String catalog;
    public final boolean isReadOnly;
    public final boolean isAutoCommit;
    public int transactionIsolation;
    protected final PoolUtilities poolUtils;
    protected final HikariConfig configuration;
    protected final AtomicInteger totalConnections;
    protected final ConcurrentBag<PoolBagEntry> connectionBag;
    protected final ThreadPoolExecutor addConnectionExecutor;
    protected final ThreadPoolExecutor closeConnectionExecutor;
    protected final ScheduledThreadPoolExecutor houseKeepingExecutorService;
    protected final boolean isUseJdbc4Validation;
    protected final boolean isIsolateInternalQueries;
    protected volatile int poolState;
    protected volatile long connectionTimeout;
    protected volatile long validationTimeout;
    private final LeakTask leakTask;
    private final DataSource dataSource;
    private final GlobalPoolLock suspendResumeLock;
    private final IConnectionCustomizer connectionCustomizer;
    private final AtomicReference<Throwable> lastConnectionFailure;
    private final String username;
    private final String password;
    private volatile MetricsTracker metricsTracker;
    private volatile boolean isRecordMetrics;

    public BaseHikariPool(HikariConfig configuration) {
        this(configuration, configuration.getUsername(), configuration.getPassword());
    }

    public BaseHikariPool(HikariConfig configuration, String username, String password) {
        this.username = username;
        this.password = password;
        this.configuration = configuration;
        this.poolUtils = new PoolUtilities(configuration);
        this.connectionBag = this.createConcurrentBag(this);
        this.totalConnections = new AtomicInteger();
        this.connectionTimeout = configuration.getConnectionTimeout();
        this.validationTimeout = configuration.getValidationTimeout();
        this.lastConnectionFailure = new AtomicReference();
        this.isReadOnly = configuration.isReadOnly();
        this.isAutoCommit = configuration.isAutoCommit();
        this.suspendResumeLock = configuration.isAllowPoolSuspension() ? new GlobalPoolLock(true) : GlobalPoolLock.FAUX_LOCK;
        this.catalog = configuration.getCatalog();
        this.connectionCustomizer = this.initializeCustomizer();
        this.transactionIsolation = UtilityElf.getTransactionIsolation(configuration.getTransactionIsolation());
        this.isIsolateInternalQueries = configuration.isIsolateInternalQueries();
        this.isUseJdbc4Validation = configuration.getConnectionTestQuery() == null;
        this.setMetricRegistry(configuration.getMetricRegistry());
        this.setHealthCheckRegistry(configuration.getHealthCheckRegistry());
        this.dataSource = this.poolUtils.initializeDataSource(configuration.getDataSourceClassName(), configuration.getDataSource(), configuration.getDataSourceProperties(), configuration.getDriverClassName(), configuration.getJdbcUrl(), username, password);
        this.addConnectionExecutor = UtilityElf.createThreadPoolExecutor(configuration.getMaximumPoolSize(), "HikariCP connection filler (pool " + configuration.getPoolName() + ")", configuration.getThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
        this.closeConnectionExecutor = UtilityElf.createThreadPoolExecutor(4, "HikariCP connection closer (pool " + configuration.getPoolName() + ")", configuration.getThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        long delayPeriod = Long.getLong("com.zaxxer.hikari.housekeeping.periodMs", TimeUnit.SECONDS.toMillis(30L));
        ThreadFactory threadFactory = configuration.getThreadFactory() != null ? configuration.getThreadFactory() : new DefaultThreadFactory("Hikari Housekeeping Timer (pool " + configuration.getPoolName() + ")", true);
        this.houseKeepingExecutorService = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.DiscardPolicy());
        this.houseKeepingExecutorService.scheduleAtFixedRate(this.getHouseKeeper(), delayPeriod, delayPeriod, TimeUnit.MILLISECONDS);
        this.houseKeepingExecutorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.leakTask = configuration.getLeakDetectionThreshold() == 0L ? LeakTask.NO_LEAK : new LeakTask(configuration.getLeakDetectionThreshold(), this.houseKeepingExecutorService);
        UtilityElf.setRemoveOnCancelPolicy(this.houseKeepingExecutorService);
        this.poolUtils.setLoginTimeout(this.dataSource, this.connectionTimeout);
        HikariMBeanElf.registerMBeans(configuration, this);
        this.initializeConnections();
    }

    public final Connection getConnection() throws SQLException {
        return this.getConnection(this.connectionTimeout);
    }

    public final Connection getConnection(long hardTimeout) throws SQLException {
        this.suspendResumeLock.acquire();
        long timeout = hardTimeout;
        long start = System.currentTimeMillis();
        MetricsTracker.MetricsContext metricsContext = this.isRecordMetrics ? this.metricsTracker.recordConnectionRequest(start) : MetricsTracker.NO_CONTEXT;
        try {
            do {
                PoolBagEntry bagEntry;
                if ((bagEntry = this.connectionBag.borrow(timeout, TimeUnit.MILLISECONDS)) == null) {
                    break;
                }
                long now = System.currentTimeMillis();
                if (!bagEntry.evicted && (now - bagEntry.lastAccess <= ALIVE_BYPASS_WINDOW || this.isConnectionAlive(bagEntry.connection))) {
                    metricsContext.setConnectionLastOpen(bagEntry, now);
                    metricsContext.stop();
                    IHikariConnectionProxy iHikariConnectionProxy = ProxyFactory.getProxyConnection((HikariPool)this, bagEntry, this.leakTask.start(bagEntry), this.isAutoCommit);
                    return iHikariConnectionProxy;
                }
                this.closeConnection(bagEntry, "(connection evicted or dead)");
                timeout = hardTimeout - UtilityElf.elapsedTimeMs(start);
            } while (timeout > 0L);
        }
        catch (InterruptedException e) {
            throw new SQLException("Interrupted during connection acquisition", e);
        }
        finally {
            this.suspendResumeLock.release();
        }
        this.logPoolState("Timeout failure ");
        String sqlState = null;
        Throwable originalException = this.lastConnectionFailure.getAndSet(null);
        if (originalException instanceof SQLException) {
            sqlState = ((SQLException)originalException).getSQLState();
        }
        throw new SQLTimeoutException(String.format("Timeout after %dms of waiting for a connection.", UtilityElf.elapsedTimeMs(start)), sqlState, originalException);
    }

    public final void releaseConnection(PoolBagEntry bagEntry) {
        this.metricsTracker.recordConnectionUsage(bagEntry);
        if (bagEntry.evicted) {
            this.LOGGER.debug("Connection returned to pool {} is broken or evicted.  Closing connection.", (Object)this.configuration.getPoolName());
            this.closeConnection(bagEntry, "(connection broken or evicted)");
        } else {
            this.connectionBag.requite(bagEntry);
        }
    }

    public final void shutdown() throws InterruptedException {
        if (this.poolState != 2) {
            this.poolState = 2;
            this.LOGGER.info("HikariCP pool {} is shutting down.", (Object)this.configuration.getPoolName());
            this.logPoolState("Before shutdown ");
            this.connectionBag.close();
            this.softEvictConnections();
            this.houseKeepingExecutorService.shutdown();
            this.addConnectionExecutor.shutdownNow();
            this.houseKeepingExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
            this.addConnectionExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            ThreadPoolExecutor assassinExecutor = UtilityElf.createThreadPoolExecutor(this.configuration.getMaximumPoolSize(), "HikariCP connection assassin", this.configuration.getThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
            long start = System.currentTimeMillis();
            do {
                this.softEvictConnections();
                this.abortActiveConnections(assassinExecutor);
            } while (this.getTotalConnections() > 0 && UtilityElf.elapsedTimeMs(start) < TimeUnit.SECONDS.toMillis(5L));
            assassinExecutor.shutdown();
            assassinExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            this.closeConnectionExecutor.shutdown();
            this.closeConnectionExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            this.logPoolState("After shutdown ");
            HikariMBeanElf.unregisterMBeans(this.configuration, this);
            this.metricsTracker.close();
        }
    }

    public final void evictConnection(IHikariConnectionProxy proxyConnection) {
        this.closeConnection(proxyConnection.getPoolBagEntry(), "(connection evicted by user)");
    }

    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public final HikariConfig getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return this.configuration.getPoolName();
    }

    @Override
    public final int getActiveConnections() {
        return this.connectionBag.getCount(1);
    }

    @Override
    public final int getIdleConnections() {
        return this.connectionBag.getCount(0);
    }

    @Override
    public final int getTotalConnections() {
        return this.connectionBag.size() - this.connectionBag.getCount(-1);
    }

    @Override
    public final int getThreadsAwaitingConnection() {
        return this.connectionBag.getPendingQueue();
    }

    @Override
    public final void suspendPool() {
        if (this.suspendResumeLock == GlobalPoolLock.FAUX_LOCK) {
            throw new IllegalStateException("Pool " + this.configuration.getPoolName() + " is not suspendable");
        }
        if (this.poolState != 1) {
            this.suspendResumeLock.suspend();
            this.poolState = 1;
        }
    }

    @Override
    public final void resumePool() {
        if (this.poolState == 1) {
            this.poolState = 0;
            this.addBagItem();
            this.suspendResumeLock.resume();
        }
    }

    public void setMetricRegistry(Object metricRegistry) {
        this.isRecordMetrics = metricRegistry != null;
        this.metricsTracker = this.isRecordMetrics ? new CodaHaleMetricsTracker(this, (MetricRegistry)metricRegistry) : new MetricsTracker(this);
    }

    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        if (healthCheckRegistry != null) {
            CodahaleHealthChecker.registerHealthChecks(this, (HealthCheckRegistry)healthCheckRegistry);
        }
    }

    @Override
    public Future<Boolean> addBagItem() {
        FutureTask<Boolean> future = new FutureTask<Boolean>(new Runnable(){

            @Override
            public void run() {
                long sleepBackoff = 200L;
                int minimumIdle = BaseHikariPool.this.configuration.getMinimumIdle();
                int maxPoolSize = BaseHikariPool.this.configuration.getMaximumPoolSize();
                while (BaseHikariPool.this.poolState == 0 && BaseHikariPool.this.totalConnections.get() < maxPoolSize && BaseHikariPool.this.getIdleConnections() <= minimumIdle && !BaseHikariPool.this.addConnection()) {
                    UtilityElf.quietlySleep(sleepBackoff);
                    sleepBackoff = Math.min(BaseHikariPool.this.connectionTimeout / 2L, (long)((double)sleepBackoff * 1.5));
                }
            }
        }, true);
        this.addConnectionExecutor.execute(future);
        return future;
    }

    protected final boolean addConnection() {
        if (this.totalConnections.incrementAndGet() <= this.configuration.getMaximumPoolSize()) {
            Connection connection = null;
            try {
                Connection connection2 = connection = this.username == null && this.password == null ? this.dataSource.getConnection() : this.dataSource.getConnection(this.username, this.password);
                if (this.isUseJdbc4Validation && !this.poolUtils.isJdbc4ValidationSupported(connection)) {
                    throw new SQLException("JDBC4 Connection.isValid() method not supported, connection test query must be configured");
                }
                int originalTimeout = this.poolUtils.getAndSetNetworkTimeout(connection, this.connectionTimeout);
                this.transactionIsolation = this.transactionIsolation < 0 ? connection.getTransactionIsolation() : this.transactionIsolation;
                this.poolUtils.setupConnection(connection, this.isAutoCommit, this.isReadOnly, this.transactionIsolation, this.catalog);
                this.connectionCustomizer.customize(connection);
                this.poolUtils.executeSql(connection, this.configuration.getConnectionInitSql(), this.isAutoCommit);
                this.poolUtils.setNetworkTimeout(connection, originalTimeout);
                this.connectionBag.add(new PoolBagEntry(connection, this));
                this.lastConnectionFailure.set(null);
                return true;
            }
            catch (Exception e) {
                this.lastConnectionFailure.set(e);
                if (this.poolState == 0) {
                    this.LOGGER.debug("Connection attempt to database {} failed: {}", this.configuration.getPoolName(), e.getMessage(), e);
                }
                this.poolUtils.quietlyCloseConnection(connection, "(exception during connection creation)");
            }
        }
        this.totalConnections.decrementAndGet();
        return false;
    }

    protected void fillPool() {
        int connectionsToAdd = this.configuration.getMinimumIdle() - this.getIdleConnections();
        for (int i = 0; i < connectionsToAdd; ++i) {
            this.addBagItem();
        }
        if (connectionsToAdd > 0 && this.LOGGER.isDebugEnabled()) {
            this.addConnectionExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    BaseHikariPool.this.logPoolState("After fill ");
                }
            });
        }
    }

    protected abstract void closeConnection(PoolBagEntry var1, String var2);

    protected abstract boolean isConnectionAlive(Connection var1);

    protected abstract void abortActiveConnections(ExecutorService var1) throws InterruptedException;

    protected abstract ConcurrentBag<PoolBagEntry> createConcurrentBag(IBagStateListener var1);

    protected abstract Runnable getHouseKeeper();

    private void initializeConnections() {
        if (this.configuration.isInitializationFailFast()) {
            try {
                try {
                    if (!this.addConnection()) {
                        this.shutdown();
                        throw new PoolInitializationException(this.lastConnectionFailure.getAndSet(null));
                    }
                    ConnectionProxy connection = (ConnectionProxy)this.getConnection();
                    connection.getPoolBagEntry().evicted = this.configuration.getMinimumIdle() == 0;
                    connection.close();
                }
                catch (SQLException e) {
                    this.shutdown();
                    throw new PoolInitializationException(e);
                }
            }
            catch (InterruptedException ie) {
                throw new PoolInitializationException(ie);
            }
        }
        this.fillPool();
    }

    private IConnectionCustomizer initializeCustomizer() {
        if (this.configuration.getConnectionCustomizerClassName() != null) {
            return UtilityElf.createInstance(this.configuration.getConnectionCustomizerClassName(), IConnectionCustomizer.class, new Object[0]);
        }
        return this.configuration.getConnectionCustomizer();
    }

    public final void logPoolState(String ... prefix) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("{}pool stats {} (total={}, inUse={}, avail={}, waiting={})", prefix.length > 0 ? prefix[0] : "", this.configuration.getPoolName(), this.getTotalConnections(), this.getActiveConnections(), this.getIdleConnections(), this.getThreadsAwaitingConnection());
        }
    }
}

