/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.opsworks.model.Source;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneStackRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String sourceStackId;
    private String name;
    private String region;
    private Map<String, String> attributes;
    private String serviceRoleArn;
    private String defaultInstanceProfileArn;
    private String defaultOs;
    private String hostnameTheme;
    private String defaultAvailabilityZone;
    private String customJson;
    private Boolean useCustomCookbooks;
    private Source customCookbooksSource;
    private String defaultSshKeyName;
    private Boolean clonePermissions;
    private List<String> cloneAppIds;

    public String getSourceStackId() {
        return this.sourceStackId;
    }

    public void setSourceStackId(String sourceStackId) {
        this.sourceStackId = sourceStackId;
    }

    public CloneStackRequest withSourceStackId(String sourceStackId) {
        this.sourceStackId = sourceStackId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CloneStackRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public CloneStackRequest withRegion(String region) {
        this.region = region;
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CloneStackRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public CloneStackRequest withServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
        return this;
    }

    public String getDefaultInstanceProfileArn() {
        return this.defaultInstanceProfileArn;
    }

    public void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
        this.defaultInstanceProfileArn = defaultInstanceProfileArn;
    }

    public CloneStackRequest withDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
        this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        return this;
    }

    public String getDefaultOs() {
        return this.defaultOs;
    }

    public void setDefaultOs(String defaultOs) {
        this.defaultOs = defaultOs;
    }

    public CloneStackRequest withDefaultOs(String defaultOs) {
        this.defaultOs = defaultOs;
        return this;
    }

    public String getHostnameTheme() {
        return this.hostnameTheme;
    }

    public void setHostnameTheme(String hostnameTheme) {
        this.hostnameTheme = hostnameTheme;
    }

    public CloneStackRequest withHostnameTheme(String hostnameTheme) {
        this.hostnameTheme = hostnameTheme;
        return this;
    }

    public String getDefaultAvailabilityZone() {
        return this.defaultAvailabilityZone;
    }

    public void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
        this.defaultAvailabilityZone = defaultAvailabilityZone;
    }

    public CloneStackRequest withDefaultAvailabilityZone(String defaultAvailabilityZone) {
        this.defaultAvailabilityZone = defaultAvailabilityZone;
        return this;
    }

    public String getCustomJson() {
        return this.customJson;
    }

    public void setCustomJson(String customJson) {
        this.customJson = customJson;
    }

    public CloneStackRequest withCustomJson(String customJson) {
        this.customJson = customJson;
        return this;
    }

    public Boolean isUseCustomCookbooks() {
        return this.useCustomCookbooks;
    }

    public void setUseCustomCookbooks(Boolean useCustomCookbooks) {
        this.useCustomCookbooks = useCustomCookbooks;
    }

    public CloneStackRequest withUseCustomCookbooks(Boolean useCustomCookbooks) {
        this.useCustomCookbooks = useCustomCookbooks;
        return this;
    }

    public Boolean getUseCustomCookbooks() {
        return this.useCustomCookbooks;
    }

    public Source getCustomCookbooksSource() {
        return this.customCookbooksSource;
    }

    public void setCustomCookbooksSource(Source customCookbooksSource) {
        this.customCookbooksSource = customCookbooksSource;
    }

    public CloneStackRequest withCustomCookbooksSource(Source customCookbooksSource) {
        this.customCookbooksSource = customCookbooksSource;
        return this;
    }

    public String getDefaultSshKeyName() {
        return this.defaultSshKeyName;
    }

    public void setDefaultSshKeyName(String defaultSshKeyName) {
        this.defaultSshKeyName = defaultSshKeyName;
    }

    public CloneStackRequest withDefaultSshKeyName(String defaultSshKeyName) {
        this.defaultSshKeyName = defaultSshKeyName;
        return this;
    }

    public Boolean isClonePermissions() {
        return this.clonePermissions;
    }

    public void setClonePermissions(Boolean clonePermissions) {
        this.clonePermissions = clonePermissions;
    }

    public CloneStackRequest withClonePermissions(Boolean clonePermissions) {
        this.clonePermissions = clonePermissions;
        return this;
    }

    public Boolean getClonePermissions() {
        return this.clonePermissions;
    }

    public List<String> getCloneAppIds() {
        if (this.cloneAppIds == null) {
            this.cloneAppIds = new ArrayList<String>();
        }
        return this.cloneAppIds;
    }

    public void setCloneAppIds(Collection<String> cloneAppIds) {
        if (cloneAppIds == null) {
            this.cloneAppIds = null;
            return;
        }
        ArrayList<String> cloneAppIdsCopy = new ArrayList<String>(cloneAppIds.size());
        cloneAppIdsCopy.addAll(cloneAppIds);
        this.cloneAppIds = cloneAppIdsCopy;
    }

    public CloneStackRequest withCloneAppIds(String ... cloneAppIds) {
        if (this.getCloneAppIds() == null) {
            this.setCloneAppIds(new ArrayList<String>(cloneAppIds.length));
        }
        for (String value : cloneAppIds) {
            this.getCloneAppIds().add(value);
        }
        return this;
    }

    public CloneStackRequest withCloneAppIds(Collection<String> cloneAppIds) {
        if (cloneAppIds == null) {
            this.cloneAppIds = null;
        } else {
            ArrayList<String> cloneAppIdsCopy = new ArrayList<String>(cloneAppIds.size());
            cloneAppIdsCopy.addAll(cloneAppIds);
            this.cloneAppIds = cloneAppIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceStackId() != null) {
            sb.append("SourceStackId: " + this.getSourceStackId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: " + this.getRegion() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: " + this.getServiceRoleArn() + ",");
        }
        if (this.getDefaultInstanceProfileArn() != null) {
            sb.append("DefaultInstanceProfileArn: " + this.getDefaultInstanceProfileArn() + ",");
        }
        if (this.getDefaultOs() != null) {
            sb.append("DefaultOs: " + this.getDefaultOs() + ",");
        }
        if (this.getHostnameTheme() != null) {
            sb.append("HostnameTheme: " + this.getHostnameTheme() + ",");
        }
        if (this.getDefaultAvailabilityZone() != null) {
            sb.append("DefaultAvailabilityZone: " + this.getDefaultAvailabilityZone() + ",");
        }
        if (this.getCustomJson() != null) {
            sb.append("CustomJson: " + this.getCustomJson() + ",");
        }
        if (this.isUseCustomCookbooks() != null) {
            sb.append("UseCustomCookbooks: " + this.isUseCustomCookbooks() + ",");
        }
        if (this.getCustomCookbooksSource() != null) {
            sb.append("CustomCookbooksSource: " + this.getCustomCookbooksSource() + ",");
        }
        if (this.getDefaultSshKeyName() != null) {
            sb.append("DefaultSshKeyName: " + this.getDefaultSshKeyName() + ",");
        }
        if (this.isClonePermissions() != null) {
            sb.append("ClonePermissions: " + this.isClonePermissions() + ",");
        }
        if (this.getCloneAppIds() != null) {
            sb.append("CloneAppIds: " + this.getCloneAppIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceStackId() == null ? 0 : this.getSourceStackId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultInstanceProfileArn() == null ? 0 : this.getDefaultInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultOs() == null ? 0 : this.getDefaultOs().hashCode());
        hashCode = 31 * hashCode + (this.getHostnameTheme() == null ? 0 : this.getHostnameTheme().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAvailabilityZone() == null ? 0 : this.getDefaultAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getCustomJson() == null ? 0 : this.getCustomJson().hashCode());
        hashCode = 31 * hashCode + (this.isUseCustomCookbooks() == null ? 0 : this.isUseCustomCookbooks().hashCode());
        hashCode = 31 * hashCode + (this.getCustomCookbooksSource() == null ? 0 : this.getCustomCookbooksSource().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultSshKeyName() == null ? 0 : this.getDefaultSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.isClonePermissions() == null ? 0 : this.isClonePermissions().hashCode());
        hashCode = 31 * hashCode + (this.getCloneAppIds() == null ? 0 : ((Object)this.getCloneAppIds()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloneStackRequest)) {
            return false;
        }
        CloneStackRequest other = (CloneStackRequest)obj;
        if (other.getSourceStackId() == null ^ this.getSourceStackId() == null) {
            return false;
        }
        if (other.getSourceStackId() != null && !other.getSourceStackId().equals(this.getSourceStackId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !((Object)other.getAttributes()).equals(this.getAttributes())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getDefaultInstanceProfileArn() == null ^ this.getDefaultInstanceProfileArn() == null) {
            return false;
        }
        if (other.getDefaultInstanceProfileArn() != null && !other.getDefaultInstanceProfileArn().equals(this.getDefaultInstanceProfileArn())) {
            return false;
        }
        if (other.getDefaultOs() == null ^ this.getDefaultOs() == null) {
            return false;
        }
        if (other.getDefaultOs() != null && !other.getDefaultOs().equals(this.getDefaultOs())) {
            return false;
        }
        if (other.getHostnameTheme() == null ^ this.getHostnameTheme() == null) {
            return false;
        }
        if (other.getHostnameTheme() != null && !other.getHostnameTheme().equals(this.getHostnameTheme())) {
            return false;
        }
        if (other.getDefaultAvailabilityZone() == null ^ this.getDefaultAvailabilityZone() == null) {
            return false;
        }
        if (other.getDefaultAvailabilityZone() != null && !other.getDefaultAvailabilityZone().equals(this.getDefaultAvailabilityZone())) {
            return false;
        }
        if (other.getCustomJson() == null ^ this.getCustomJson() == null) {
            return false;
        }
        if (other.getCustomJson() != null && !other.getCustomJson().equals(this.getCustomJson())) {
            return false;
        }
        if (other.isUseCustomCookbooks() == null ^ this.isUseCustomCookbooks() == null) {
            return false;
        }
        if (other.isUseCustomCookbooks() != null && !other.isUseCustomCookbooks().equals(this.isUseCustomCookbooks())) {
            return false;
        }
        if (other.getCustomCookbooksSource() == null ^ this.getCustomCookbooksSource() == null) {
            return false;
        }
        if (other.getCustomCookbooksSource() != null && !other.getCustomCookbooksSource().equals(this.getCustomCookbooksSource())) {
            return false;
        }
        if (other.getDefaultSshKeyName() == null ^ this.getDefaultSshKeyName() == null) {
            return false;
        }
        if (other.getDefaultSshKeyName() != null && !other.getDefaultSshKeyName().equals(this.getDefaultSshKeyName())) {
            return false;
        }
        if (other.isClonePermissions() == null ^ this.isClonePermissions() == null) {
            return false;
        }
        if (other.isClonePermissions() != null && !other.isClonePermissions().equals(this.isClonePermissions())) {
            return false;
        }
        if (other.getCloneAppIds() == null ^ this.getCloneAppIds() == null) {
            return false;
        }
        return other.getCloneAppIds() == null || ((Object)other.getCloneAppIds()).equals(this.getCloneAppIds());
    }
}

