/*
 * Decompiled with CFR 0.152.
 */
package io.intino.confloader.wrapper;

import io.intino.Configuration;
import io.intino.confloader.Safe;
import io.intino.confloader.wrapper.WrapperArtifact;
import io.intino.confloader.wrapper.WrapperReleaseRepository;
import io.intino.confloader.wrapper.WrapperSnapshotRepository;
import io.intino.legio.model.LegioGraph;
import io.intino.legio.model.Repository;
import java.util.List;
import java.util.stream.Collectors;

public class WrapperConfiguration
implements Configuration {
    private final LegioGraph graph;

    public WrapperConfiguration(LegioGraph graph) {
        this.graph = graph;
    }

    public Configuration.Artifact artifact() {
        return new WrapperArtifact(this.graph.artifact());
    }

    public List<Configuration.Server> servers() {
        return null;
    }

    public List<Configuration.RunConfiguration> runConfigurations() {
        return null;
    }

    public List<Configuration.Repository> repositories() {
        List<Configuration.Repository> repos = this.graph.repositoryList().stream().filter(r -> r.release() != null).map(WrapperReleaseRepository::new).collect(Collectors.toList());
        repos.addAll(this.graph.repositoryList().stream().filter(r -> r.snapshot() != null).map(WrapperSnapshotRepository::new).toList());
        repos.addAll(Safe.safe(() -> this.graph.project().repositoryList(), List.of()).stream().map(Repository.class::cast).filter(r -> r.release() != null).map(WrapperReleaseRepository::new).toList());
        repos.addAll(Safe.safe(() -> this.graph.project().repositoryList(), List.of()).stream().map(Repository.class::cast).filter(r -> r.snapshot() != null).map(WrapperSnapshotRepository::new).toList());
        return repos;
    }
}

