package io.intino.cesar.datahub.entities;

import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.Arrays;
import java.util.stream.Collectors;

public class User extends io.intino.ness.master.model.Entity {

	protected static final String LIST_SEP = ",";

	protected final io.intino.cesar.datahub.MasterTerminal master;

	protected String name;
	protected String displayName;
	protected String email;

	public User(String id, io.intino.cesar.datahub.MasterTerminal master) {
		super(id);
		this.master = java.util.Objects.requireNonNull(master);
	}

	public User(TripletRecord record, io.intino.cesar.datahub.MasterTerminal master) {
		this(record.id(), master);
		record.triplets().forEach(this::add);
	}

	public String name() {
		return name;
	}

	public User name(String name) {
		this.name = name;
		return this;
	}

	public String displayName() {
		return displayName;
	}

	public User displayName(String displayName) {
		this.displayName = displayName;
		return this;
	}

	public String email() {
		return email;
	}

	public User email(String email) {
		this.email = email;
		return this;
	}

	public User add(Triplet triplet) {
		switch(triplet.predicate()) {
			case "name": addName(triplet); break;
			case "displayName": addDisplayName(triplet); break;
			case "email": addEmail(triplet); break;
			default: super.add(triplet); break;
		}
		return (User) this;
	}

	public User remove(Triplet triplet) {
		switch(triplet.predicate()) {
			case "name": removeName(triplet); break;
			case "displayName": removeDisplayName(triplet); break;
			case "email": removeEmail(triplet); break;
			default: super.remove(triplet); break;
		}
		return (User) this;
	}

	public List<Triplet> triplets() {
		final java.util.ArrayList<Triplet> triplets = new java.util.ArrayList<>();
		triplets.add(new Triplet(id().get(), "name", String.valueOf(name)));
		triplets.add(new Triplet(id().get(), "displayName", String.valueOf(displayName)));
		triplets.add(new Triplet(id().get(), "email", String.valueOf(email)));
		triplets.addAll(super.extraTriplets().values());
		return triplets;
	}

	protected void addName(Triplet triplet) {
		this.name = triplet.value();
	}

	protected void removeName(Triplet triplet) {
		this.name = null;
	}

	protected void addDisplayName(Triplet triplet) {
		this.displayName = triplet.value();
	}

	protected void removeDisplayName(Triplet triplet) {
		this.displayName = null;
	}

	protected void addEmail(Triplet triplet) {
		this.email = triplet.value();
	}

	protected void removeEmail(Triplet triplet) {
		this.email = null;
	}
}