package io.intino.cesar.datahub.entities;

import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Team extends io.intino.ness.master.model.Entity {

	protected static final String LIST_SEP = ",";

	protected final io.intino.cesar.datahub.MasterTerminal master;

	protected String displayName;
	protected List<Channel> channels;

	public Team(String id, io.intino.cesar.datahub.MasterTerminal master) {
		super(id);
		this.master = java.util.Objects.requireNonNull(master);
	}

	public Team(TripletRecord record, io.intino.cesar.datahub.MasterTerminal master) {
		this(record.id(), master);
		record.triplets().forEach(this::add);
	}

	public String displayName() {
		return displayName;
	}

	public Team displayName(String displayName) {
		this.displayName = displayName;
		return this;
	}

	public List<Channel> channels() {
		return channels;
	}

	public Team channels(List<Channel> channels) {
		this.channels = channels;
		return this;
	}

	public Team add(Triplet triplet) {
		switch(triplet.predicate()) {
			case "displayName": addDisplayName(triplet); break;
			case "channels": addChannels(triplet); break;
			default: super.add(triplet); break;
		}
		return (Team) this;
	}

	public Team remove(Triplet triplet) {
		switch(triplet.predicate()) {
			case "displayName": removeDisplayName(triplet); break;
			case "channels": removeChannels(triplet); break;
			default: super.remove(triplet); break;
		}
		return (Team) this;
	}

	public List<Triplet> triplets() {
		final java.util.ArrayList<Triplet> triplets = new java.util.ArrayList<>();
		triplets.add(new Triplet(id().get(), "displayName", String.valueOf(displayName)));
		triplets.add(new Triplet(id().get(), "channels", master.serializer().serialize(new TripletRecord(channels.stream().flatMap(e -> e.triplets().stream()).collect(Collectors.toMap(Triplet::subject, t->t))))));
		triplets.addAll(super.extraTriplets().values());
		return triplets;
	}

	protected void addDisplayName(Triplet triplet) {
		this.displayName = triplet.value();
	}

	protected void removeDisplayName(Triplet triplet) {
		this.displayName = null;
	}

	protected void addChannels(Triplet triplet) {
		if(triplet.value() == null) {
			this.channels = null;
			return;
		}

		io.intino.ness.master.serialization.MasterSerializer serializer = master.serializer();
		String[] items = triplet.value().split(LIST_SEP);
		this.channels = new ArrayList<>(items.length);

		for(String serializedItem : items) {
			TripletRecord item = serializer.deserialize(serializedItem.trim());
			Channel entity = new Channel(item.id(), master);
			this.channels.add(entity);
		}
	}

	protected void removeChannels(Triplet triplet) {
		this.channels = null;
	}
}