package io.intino.cesar.datahub.entities;

import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Channel extends io.intino.ness.master.model.Entity {

	protected static final String LIST_SEP = ",";

	protected final io.intino.cesar.datahub.MasterTerminal master;

	protected String displayName;

	public Channel(String id, io.intino.cesar.datahub.MasterTerminal master) {
		super(id);
		this.master = java.util.Objects.requireNonNull(master);
	}

	public Channel(TripletRecord record, io.intino.cesar.datahub.MasterTerminal master) {
		this(record.id(), master);
		record.triplets().forEach(this::add);
	}

	public String displayName() {
		return displayName;
	}

	public Channel displayName(String displayName) {
		this.displayName = displayName;
		return this;
	}

	public Channel add(Triplet triplet) {
		switch(triplet.predicate()) {
			case "displayName": addDisplayName(triplet); break;
			default: super.add(triplet); break;
		}
		return (Channel) this;
	}

	public Channel remove(Triplet triplet) {
		switch(triplet.predicate()) {
			case "displayName": removeDisplayName(triplet); break;
			default: super.remove(triplet); break;
		}
		return (Channel) this;
	}

	public List<Triplet> triplets() {
		final java.util.ArrayList<Triplet> triplets = new java.util.ArrayList<>();
		triplets.add(new Triplet(id().get(), "displayName", String.valueOf(displayName)));
		triplets.addAll(super.extraTriplets().values());
		return triplets;
	}

	protected void addDisplayName(Triplet triplet) {
		this.displayName = triplet.value();
	}

	protected void removeDisplayName(Triplet triplet) {
		this.displayName = null;
	}
}